    <?php
    //used in file download url
    $content_slug = $response['data']['query']['keyword']['slug'];
    ?>

    <div class="app-content content mt-3 mt-sm-0">
        <div class="content-overlay"></div>        
        <div class="content-wrapper">
            <div class="content-header row d-none d-sm-block">
                <div class="content-body col-md-12 mb-2">
                    <?php echo $CFG->g_ad_top_banner; ?>
                </div>
            </div>
            <article>
            <div class="content-detached content-left">
                <div class="content-body">
                    <section class="row">
                        <div class="col-sm-12">
                            <!-- Home -->
                            <div id="home" class="card shadow-none">
                                <div class="card-header">
                                    <h1><?php echo $content_title ?></h1>
                                </div>
                                <div class="card-content">
                                    <div class="card-body p-0">                                        
                                        <?php
                                        $result_exists = false;
                                        //print_r($response['data']['results']);
                                        if(isset($response['data']['results']) && count($response['data']['results']) > 0) {
                                            $result_exists = true;
                                        ?>
                                        <div class="card-text">
                                        <p class="font-medium-1">Showing top <?php echo count($response['data']['results']) ?> worksheets in the category - <b><?php echo $content_title; ?></b>.</p>
                                        <p>Some of the worksheets displayed are <?php echo str_replace('|', ', ', $clean_piped_titles); ?>.</p>
                                        <p><em>Once you find your worksheet, click on pop-out icon or print icon to worksheet to print or download. Worksheet will open in a new window. You can & download or print using the browser document reader options.</em></p>
                                        </div>
                                        <div class="card">
                                        <div class="card-content">
                                            <div class="card-body p-0">
                                            <div class="card-text"><?php echo $CFG->g_ad_body_main; ?></div>
                                            </div>
                                        </div>
                                        </div>
                                        <?php
                                        // social locker
                                        if($CFG->show_locker) {
                                        echo '<div class="to-lock">';
                                        }
                                        $ri = 0;
                                        $gviewer_url = 'https://docs.google.com/viewerng/viewer?url=';

                                        foreach ($response['data']['results'] as $result) {
                                            if($ri > 0 && $ri % 2 != 0) { // added 22nd Apr 2019 to increase body ads
                                                echo '<div class="card"><div class="card-content"><div class="card-body p-0">' . $CFG->g_ad_body_main . '</div></div></div>';
                                            }
                                            $iframe_id = 'result' . $ri;
                                            $embed_url = $gviewer_url . $result['url'].'&hl=en_US&embedded=true';

                                            $downloadbtn_id = 'btnresult' . $ri;
                                            $fkey = $content_slug;
                                            $findex = $ri + 1;
                                            $fname = $fkey . '-worksheet-' . $findex . '.pdf';                                                        
                                            $gip = isset($geo_info['data']['ip']) ? $geo_info['data']['ip'] : 'NA';
                                            $giso = isset($geo_info['data']['country_iso']) ? $geo_info['data']['country_iso'] : 'NA';
                                            $gcn = isset($geo_info['data']['country_name']) ? $geo_info['data']['country_name'] : 'NA';
                                            $download_url = $CFG->download_service_url . 'gi=' . $gip . '&gs=' . $giso . '&gc=' . $gcn . '&k=' . $fkey . '&i=' . $findex . '&u=' . $result['url'];
                                        ?>  
                                            <div class="card border rounded">
                                                <div class="card-header border-bottom border-bottom-lighten-5">
                                                    <h6 class="card-title text-capitalize" id="heading-multiple-icons"><?php echo $result['cleantitle']; ?></h6>
                                                    <a class="heading-elements-toggle"><i class="fa fa-ellipsis-v font-medium-3"></i></a>
                                                    <div class="heading-elements">
                                                        <ul class="list-inline">
                                                        <li><a class="btn btn-outline-cyan mr-1" rel="nofollow noreferrer" onclick="javascript: document.getElementById('<?php echo $iframe_id; ?>').src = document.getElementById('<?php echo $iframe_id; ?>').src;"><i class="feather icon-refresh-cw"></i></a></li>
                                                        <li><a class="btn btn-outline-cyan mr-1" rel="nofollow noreferrer" onclick="javascript: w=window.open('<?php echo $gviewer_url . $result['url']; ?>&hl=en_US');" target="_blank" title="print"><i class="feather icon-printer"></i></a></li>
                                                        <li><a class="btn btn-outline-cyan" rel="nofollow noreferrer" onclick="javascript: w=window.open('<?php echo $gviewer_url . $result['url']; ?>&hl=en_US');"  target="_blank" title="open in new window"><i class="feather icon-external-link"></i></a></li>
                                                        </ul>
                                                    </div>
                                                </div>    
                                                <div class="card-content">
                                                    <div class="card-body p-0">
                                                    <?php
                                                    // original code
                                                    echo '<div class="embed-responsive embed-responsive-16by9">';
                                                    echo '<iframe id="'. $iframe_id . '" name="' . $iframe_id . '" class="embed-responsive-item bg-light lazy" data-loader="iframe" data-src="' . $embed_url . '"></iframe>';
                                                    echo '</div>';
                                                    ?>
                                                    </div>    
                                                </div>
                                                <div class="card-footer py-1">
                                                    <span class="float-right">
                                                        Not visible? <button type="button" class="btn btn-danger btn-sm mr-1" onclick="javascript: document.getElementById('<?php echo $iframe_id; ?>').src = document.getElementById('<?php echo $iframe_id; ?>').src;"><i class="fa fa-refresh"></i> Refresh</button>
                                                        <?php 
                                                        if ($CFG->show_download_button === true){
                                                        ?>
                                                            <button type="button" id="<?php echo $downloadbtn_id; ?>" class="btn btn-danger btn-sm" onclick="javascript: downloadWS('<?php echo $downloadbtn_id; ?>', '<?php echo $fname; ?>', '<?php echo $download_url; ?>');"><i class="fa fa-download"></i> Download</button>
                                                        <?php
                                                        }
                                                        ?>
                                                    </span>
                                                </div>
                                            </div>
                                            <?php
                                            // this is to show related worksheets
                                            if($ri == 3 && $CFG->show_related_ws === true) {
                                            ?>                                                        
                                            <div class="lazy" data-loader="get" data-src="/includes/ga_related_ajx?slug=<?php echo $response['data']['query']['keyword']['slug']; ?>&loc=main&t=<?php echo $content_title; ?>"></div>
                                            <?php
                                            }
                                            $ri++;
                                        } // end for loop
                                        // social locker
                                        if($CFG->show_locker) {
                                        echo '</div>';
                                        }
                                        } // if results exist
                                        else {
                                        ?>
                                        <div class="card border rounded">                                                            
                                            <div class="card-content">
                                                <div class="card-body">
                                                <div class="alert alert-warning" role="alert"><?php echo $CFG->no_results_message; ?></div>
                                                <?php
                                                // this is to show related worksheets
                                                if($CFG->show_related_ws === true) {
                                                ?>
                                                <h5>Did you mean?</h5>
                                                <div class="lazy" data-loader="get" data-src="/includes/ga_related_ajx?slug=<?php echo $response['data']['query']['keyword']['slug']; ?>&loc=main&t=<?php echo $content_title; ?>"></div>
                                                <?php
                                                }
                                                ?>
                                                </div>
                                            </div>
                                        </div>
                                        <?php
                                         }
                                        ?>
                                    </div>
                                </div>
                            </div>                          
                        </div>
                    </section>
                </div>
            </div>
            </article>    
            <div class="sidebar-detached sidebar-right sidebar-sticky">
                <div class="sidebar">
                    <div class="sidebar-content d-none d-lg-block">
                        <div class="card shadow-none border">
                            <div class="card-content">
                            <?php echo $CFG->g_ad_body_right; ?>
                            </div>
                        </div>    
                    </div>
                </div>
            </div>
        </div>
    </div>    

