    <?php
    //used in file download url
    $content_slug = $response['data']['query']['keyword']['slug'];
    ?>

    <div class="app-content content mt-3 mt-sm-0">
        <div class="content-overlay"></div>        
        <div class="content-wrapper">
            <div class="content-header row d-none d-sm-block">
                <div class="content-body col-md-12 mb-2">
                    <?php echo $CFG->g_ad_top_banner; ?>
                </div>
            </div>
            <article>
            <div class="content-detached content-left">
                <div class="content-body">
                    <section class="row">
                        <div class="col-sm-12">
                            <!-- Home -->
                            <div id="home" class="card shadow-none">
                                <div class="card-header">
                                    <h1><?php echo $content_title ?></h1>
                                </div>
                                <div class="card-content">                                     
                                    <?php
                                    $result_exists = false;
                                    //print_r($response['data']['results']);
                                    if(isset($response['data']['results']) && count($response['data']['results']) > 0) {
                                        $result_exists = true;
                                    ?>
                                    <div class="card-text">
                                        <p class="font-medium-1">Showing <?php echo count($response['data']['results']); ?> coloring pages related to - <b><?php echo $content_title; ?></b>. </p>
                                        <p>Some of the coloring page names are <?php echo str_replace('|', ', ', $clean_piped_titles); ?>.</p>
                                        <p><em>click on the coloring page to open in a new window and print. In case you don\'t find what you are looking for, use the top search bar to search again!</em></p>
                                    </div>
                                    <?php
                                    // social locker
                                    if($CFG->show_locker) {
                                    echo '<div class="to-lock">';
                                    }
                                    $i = 0;
                                    //echo '<div class="d-flex flex-wrap">';
                                    echo '<div class="card-columns">';    
                                    foreach ($response['data']['results'] as $result) {
                                    ?>
                                        <div class="card border border-light">
                                            <div class="card-content p-0">
                                                <a rel="nofollow noreferrer" href="<?php echo $result['mediaurl']; ?>" title="<?php echo $clean_titles_a[$i]; ?>" target="_blank">                                                    
                                                <img class="card-img-top img-fluid" src="<?php echo $result['thumbnail_mediaurl']; ?>" alt="<?php echo $clean_titles_a[$i]; ?>">
                                                
                                                </a>                                                    
                                            </div>
                                        </div>
                                    <?php
                                        $i++;
                                    }
                                    echo '</div>';
                                    // social locker
                                    if($CFG->show_locker) {
                                    echo '</div>';
                                    }
                                    } // if results exist
                                    else {
                                    ?>
                                    <div class="card border rounded">                                                            
                                        <div class="card-content">
                                            <div class="card-body">
                                                <div class="alert alert-warning" role="alert"><?php echo $CFG->no_results_message; ?></div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php
                                    }
                                    ?>
                                </div>
                            </div>                          
                        </div>
                    </section>
                </div>
            </div>
            </article>    
            <div class="sidebar-detached sidebar-right sidebar-sticky">
                <div class="sidebar">
                    <div class="sidebar-content d-none d-lg-block">
                        <div class="card shadow-none border">
                            <div class="card-content">
                            <?php echo $CFG->g_ad_body_right; ?>
                            </div>                            
                        </div>    
                    </div>
                </div>
            </div>
        </div>
    </div>    

