<?php
    include 'client/minifier.php';
    ob_start();
?>

<?php
    require_once 'client/bingc.lib.php';
    include 'config.php';

    global $CFG;

    $request_type = ""; // used in decide on the include page
    $page_title = $CFG->site_meta_title;
    $page_desc = $CFG->site_meta_desc;
    $page_keywords = $CFG->site_meta_keywords;
    $page_desc = $CFG->site_meta_desc;

    $content_title = '';
    $content_html = '';
    $response = '';

    $history = '';

    // add to history
    $bclient = new bingc\client();
    
    //*** Jan 12th 2019
    // this code is for getting geo info (country) for a given client ip (used for displaying sb ads)
    // IMPORTANT - this code does not return data for local IP (local testing)
    $geo_info = $bclient->get_geoip_info($_SERVER['REMOTE_ADDR'], $CFG->site_type, $_SERVER['HTTP_HOST']);

    // for testing
    //$geo_info = $bclient->get_geoip_info('43.224.158.176', 'ws', $_SERVER['HTTP_HOST']);
    //echo $geo_info['data']['log'];
    //debug_to_console($geo_info['data']);
    // Jan 12th 2019 ***//
    
    if (isset($_GET[$CFG->old_search_param]) && trim($_GET[$CFG->old_search_param] != '')) { // make sure there is no html or echo before 301 redirect

        debug_to_console("client - keyword is " . $_GET[$CFG->old_search_param]);
        // check if keyword is valid and also get slug to use in the url
        $response = $bclient->check_keyword($_GET[$CFG->old_search_param], $CFG->site_type, $_SERVER['HTTP_HOST']);

        //echo 'log ' . $response['data']['log'];
        debug_to_console($response['data']);

        // check if it is authorised request (query/keyword will be set)
        if(isset($response['data']['query'])) {

            if (!$response['data']['query']['keyword']['is_valid']) {

                debug_to_console('client - keyword is not valid');
                header("Location: $CFG->invalid_search_url");

            } else {

                $url = $CFG->site_search_uri . $response['data']['query']['keyword']['slug'];
                debug_to_console('client - redirect to ' . $url);
                header("HTTP/1.1 301 Moved Permanently");
                header("Location: $url");
            }
        }
        else {
                debug_to_console('client - unauthorised request');
                header("Location: $CFG->unauth_search_url");
        }
    }    
    else if (isset($_GET['s'])) {  // this param is set in .htaccess file as part of url rewrite

        $request_type = 'search'; // include
        //echo '[s-condition]keyword: ' . $_GET['s']."<br>";

        if(strlen($_GET['s']) <= $CFG->wscp_name_max_length) {
            $response = $bclient->get($_GET['s'], $CFG->site_type, $_SERVER['HTTP_HOST'], $geo_info);
        }
        //$response = $bclient->get($_GET['s'], $CFG->site_type, $_SERVER['HTTP_HOST'], $geo_info);

        //echo $response['data']['log'];
        debug_to_console('client - logging entire response');
        debug_to_console($response);

        if (isset($response['data']['results'])) {
            debug_to_console($response['data']['results']);
        }
        debug_to_console('client - 1');
        // check if it is authorised request (query/keyword will be set)
        if(isset($response['data']['query'])) {

            if (!$response['data']['query']['keyword']['is_valid']) {
                debug_to_console('client - keyword is not valid');
                header("Location: $CFG->invalid_search_url");

            } else {
                debug_to_console('client - 2 else');

                $page_title = $response['data']['query']['keyword']['title_text'].' Colouring Pages';
                $content_title = $response['data']['query']['keyword']['title_text'];
               
                // new page desc code improve seo
                $clean_piped_titles = $bclient->clean_result_titles($response);
                $page_desc_str = 'Showing ' . count($response['data']['results']).' colouring pages related to ' . $content_title . '. ';
				$page_desc_str .= 'Colouring pages available are ' .  str_replace('|', ', ', $clean_piped_titles) . '.';
                if(strlen($page_desc_str) >= 140) {
                    $page_desc = substr($page_desc_str, 0, strpos($page_desc_str, ' ', 140)) . '...';
                }
                else {
                    $page_desc = $page_desc_str;
                }
                // this below array containing clean titles is used to populate alt and title tags of image results
				$clean_titles_a = explode('|', $clean_piped_titles);
                
                $page_keywords = $response['data']['query']['keyword']['clean_text'];

                if(isset($response['data']['results']) && count($response['data']['results']) > 0) {
                    debug_to_console('client - 3 else before add history');
                    $bclient->add_to_history($response['data']['query']['keyword']['title_text'] . '|' . $response['data']['query']['keyword']['slug']);
                    debug_to_console('client - 4 else end');
                }
            }
        }
        else {
            debug_to_console('client - unauthorised request');
            header("Location: $CFG->unauth_search_url");
        }
    }
    else if (isset($_GET['p'])) { // this param is set in .htaccess file as part of url rewrite
        $request_type = 'page'; // include content.php
        //echo 'page: ' . $_GET['p'];

        $content = file_get_contents($CFG->site_content_json);
        $cname = $_GET['p'];
        $json_a = json_decode($content, true);
        //var_dump(json_decode($content, true));

        if (isset($json_a['categories'][$cname])) {
            //echo "content name: " . $json_a['categories'][$cname]['title'];
            $page_title = $json_a['categories'][$cname]['title'];
            $page_desc = $json_a['categories'][$cname]['title'] . " for creative kids and parents. Print and download for free.";
            $page_keywords = $json_a['categories'][$cname]['title'];

            $content_title = $json_a['categories'][$cname]['title'];
            $content_html = $json_a['categories'][$cname]['html'];
        }
        else {
            debug_to_console('client - site content data not found');
            debug_to_console('client - unauthorised request');
            header("Location: $CFG->unauth_search_url");
        }
    }
    else {
        $request_type = '';
    }

    // worksheets
    $hlinks = $bclient->get_history_links();
    $hlinks = str_replace($CFG->site_url, '', $hlinks);
    $hlinks_f = $hlinks; // for footer
    
    $hlinks_f = str_replace('<p>', '<div class="d-flex flex-wrap">', $hlinks_f);
    $hlinks_f = str_replace('<a ', '<a class="btn-link m-50" ', $hlinks_f);
    $hlinks_f = str_replace('</a>', '</a>', $hlinks_f);
    $hlinks_f = str_replace('</p>', '</div>', $hlinks_f);
    $hlinks_f = str_replace('|', '', $hlinks_f);
    
?>

<!DOCTYPE html>

<html class="loading" lang="en" data-textdirection="ltr">
    <!-- BEGIN: Head-->
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
        <base href="<?php echo $CFG->site_url; ?>" />
        <meta name="description" content="<?php echo $page_desc; ?>">
        <meta name="keywords" content="<?php echo $page_keywords; ?>">
        <meta name="author" content="Colouring-Pages">
        <title><?php echo $page_title.' - '. $CFG->site_meta_title_suffix; ?></title>
        <link rel="canonical" href="<?php echo $CFG->site_url . $_SERVER['REQUEST_URI'];?>">
        <link rel="apple-touch-icon" href="<?php echo $CFG->cdn_domain; ?>/logo.png">
        <link rel="shortcut icon" type="image/x-icon" href="<?php echo $CFG->cdn_domain; ?>/favicon.ico">
        <link href="<?php echo $CFG->cdn_domain; ?>/favicon.ico" rel="shortcut icon" type="image/vnd.microsoft.icon" />        
        <link href="https://fonts.googleapis.com/css?family=Montserrat:300,300i,400,400i,500,500i%7COpen+Sans:300,300i,400,400i,600,600i,700,700i" rel="stylesheet"  media="print" onload="this.media='all'; this.onload=null;">

        <!-- BEGIN: Vendor CSS-->
        <link rel="stylesheet" type="text/css" href="<?php echo $CFG->cdn_domain; ?>/app-assets/vendors/css/vendors.min.css" media="print" onload="this.media='all'; this.onload=null;">
        <!-- END: Vendor CSS-->

        <!-- BEGIN: Theme CSS-->
        <link rel="stylesheet" type="text/css" href="<?php echo $CFG->cdn_domain; ?>/app-assets/css/bootstrap.min.css">
        <link rel="stylesheet" type="text/css" href="<?php echo $CFG->cdn_domain; ?>/app-assets/css/bootstrap-extended.min.css">
        <link rel="stylesheet" type="text/css" href="<?php echo $CFG->cdn_domain; ?>/app-assets/css/colors.min.css" media="print" onload="this.media='all'; this.onload=null;">
        <link rel="stylesheet" type="text/css" href="<?php echo $CFG->cdn_domain; ?>/app-assets/css/components.min.css">        
        <!-- END: Theme CSS-->

        <!-- BEGIN: Page CSS-->
        <link rel="stylesheet" type="text/css" href="<?php echo $CFG->cdn_domain; ?>/app-assets/css/core/menu/menu-types/vertical-menu.min.css">
        <link rel="stylesheet" type="text/css" href="<?php echo $CFG->cdn_domain; ?>/app-assets/css/core/colors/palette-gradient.min.css" media="print" onload="this.media='all'; this.onload=null;">
        <!-- END: Page CSS-->

        <!-- BEGIN: Custom CSS-->
        <link rel="stylesheet" type="text/css" href="<?php echo $CFG->cdn_domain; ?>/assets/css/style.css" media="print" onload="this.media='all'; this.onload=null;">
        <!-- END: Custom CSS-->

        <!-- Custom CSS: You can use this stylesheet to override any Bootstrap styles and/or apply your own styles -->
        <link href="<?php echo $CFG->cdn_domain; ?>/css/custom.css" rel="stylesheet">

        <?php echo $CFG->g_analytics_script; ?>
        <?php echo $CFG->g_page_ad_script; ?>

    </head>
    <!-- END: Head-->   

    <!-- BEGIN: Body-->

    <body class="vertical-layout vertical-menu detached-right-sidebar container boxed-layout fixed-navbar container boxed-layout bg-white" data-open="click" data-menu="vertical-menu" data-col="content-detached-right-sidebar">

        <!-- BEGIN: Header-->
        <?php include 'includes/navbar.php' ?>
        <!-- END: Header-->


        <!-- BEGIN: Main Menu-->
        <!-- main menu-->
        <div class="main-menu menu-fixed menu-light menu-accordion menu-bordered" data-scroll-to-active="true">
            <!-- main menu header-->
            <!-- / main menu header-->
            <!-- main menu content-->
            <?php include 'includes/main_menu.php' ?>
            <!-- /main menu content-->
            <!-- main menu footer-->
            <!-- main menu footer-->
        </div>
        <!-- / main menu-->
        <!-- END: Main Menu-->

        <!-- BEGIN: Content-->
        <!-- includes -->
        <?php
            if($request_type === 'search') {
                include 'includes/sresults.php';
            }            
            else if($request_type === 'page') {
                include 'includes/content.php';
            }            
            else {
                //echo "redirecting to home";
                include 'includes/home.php';
            }
        ?>
        <!-- END: Content-->
        <div class="sidenav-overlay"></div>
        <div class="drag-target"></div>

        <!-- BEGIN: Footer-->
        <?php include 'includes/footer.php' ?>
        <!-- END: Footer-->


        <!-- BEGIN: Vendor JS-->
        <script src="<?php echo $CFG->cdn_domain; ?>/app-assets/vendors/js/vendors.min.js"></script>
        <!-- BEGIN Vendor JS-->

        <!-- BEGIN: Page Vendor JS-->
        <script src="<?php echo $CFG->cdn_domain; ?>/app-assets/vendors/js/ui/jquery.sticky.js"></script>
        <!-- END: Page Vendor JS-->

        <!-- jquery lazy library -->
        <script src="<?php echo $CFG->cdn_domain; ?>/dist/jqueryui/1.12.0/jquery-ui.min.js"></script>
        <script src="<?php echo $CFG->cdn_domain; ?>/dist/jquery.lazy/1.7.10/jquery.lazy.min.js" defer></script>
        <script src="<?php echo $CFG->cdn_domain; ?>/dist/jquery.lazy/1.7.10/jquery.lazy.plugins.min.js" defer></script>

        <!-- BEGIN: Theme JS-->
        <script src="<?php echo $CFG->cdn_domain; ?>/app-assets/js/core/app-menu.min.js"></script>
        <script src="<?php echo $CFG->cdn_domain; ?>/app-assets/js/core/app.min.js"></script>
        <?php /* <script src="<?php echo $CFG->cdn_domain; ?>/app-assets/js/scripts/customizer.js"></script> */ ?>
        <!-- END: Theme JS-->

        <!-- BEGIN: Page JS-->
        <script src="<?php echo $CFG->cdn_domain; ?>/app-assets/js/scripts/pages/sk-content-sidebar.js"></script>
        <!-- END: Page JS-->

        <!-- BEGIN: Page JS-->
        <!-- Initialize Bootstrap functionality -->
        <script>
            // Initialize Lazy load component
            $(function() {
                $('.lazy').lazy();
            });
            // Initialize tooltip component
            $(function () {
                $('[data-toggle="tooltip"]').tooltip();
            });
            // Initialize popover component
            $(function () {
                $('[data-toggle="popover"]').popover();
            });
        </script>
        <?php 
        // download service
        if(isset($CFG->show_download_button) && $CFG->show_download_button == true) {
        ?>
            <script>
                // download worksheet
                function downloadWS(btnid, wsfname, wsdurl) {
                    $('#'+btnid).prop('disabled', true);
                    $('#'+btnid).attr('class', 'btn btn-seconday btn-sm');
                    $('#'+btnid).html('<i class="fa fa-spinner fa-pulse fa-fw"></i> Downloading');
                    var req = new XMLHttpRequest();
                    req.open("GET", wsdurl, true);
                    req.responseType = "blob";
                    req.onreadystatechange = function () {
                        if (req.readyState === 4 && req.status === 200) {                    
                            if (typeof window.chrome !== 'undefined') {
                                // Chrome version
                                var link = document.createElement('a');
                                link.href = window.URL.createObjectURL(req.response);
                                link.download = wsfname;
                                link.click();
                            } else if (typeof window.navigator.msSaveBlob !== 'undefined') {
                                // IE version
                                var blob = new Blob([req.response], { type: 'application/pdf' });
                                window.navigator.msSaveBlob(blob, wsfname);
                            } else {
                                // Firefox version
                                var file = new File([req.response], wsfname, { type: 'application/force-download' });
                                window.open(URL.createObjectURL(file));
                            }                            
                            $('#'+btnid).attr('class', 'btn btn-outline-dark btn-sm');
                            $('#'+btnid).html('<i class="fa fa-download success"></i>&nbsp;&nbsp;Done&nbsp;&nbsp;');
                        }
                        else if (req.status > 200) {
                            $('#'+btnid).attr('class', 'btn btn-outline-dark btn-sm');
                            $('#'+btnid).html('<i class="fa fa-download warning"></i>&nbsp;&nbsp;Failed&nbsp;&nbsp;');
                        }
                    };
                    req.send();         
                }
            </script>  
        <?php
        }
        ?>
        <?php 
        // search suggestions
        if(isset($CFG->show_search_suggestion) && $CFG->show_search_suggestion == true) {
        ?>
            <script>
                $(function() {
                    var sugg_url = "/client/suggest?q=";
                    $("#s").autocomplete({
                        source : function(request, response) {
                            var skey = $("#s").val();
                            var URL = sugg_url + skey;
                            $.ajax({
                                url : URL,
                                success : function(data) {
                                        response($.map(data, function(value, key) {
                                                return {
                                                        label : value.term
                                                }
                                        })); // end response
                                },
                                dataType : 'jsonp',
                                jsonp : 'json.wrf'
                            }); // end ajax
                        }, // end source
                        minLength : 2,
                        select: function(event, ui) { 
                            $("#s").val(ui.item.value);
                            $("#sform").submit(); 
                        }
                    }) // end autocompte
                });
            </script>
        <?php
        } // end search suggestions
        ?>	
        <?php
        //if(isset($geo_info['data']['country_iso']) && in_array($geo_info['data']['country_iso'], $CFG->eu_countries)) {
        ?>
            <link rel="stylesheet" type="text/css" href="<?php echo $CFG->cdn_domain; ?>/dist/cookieconsent2/3.1.1/cookieconsent.min.css" defer/>
            <script src="<?php echo $CFG->cdn_domain; ?>/dist/cookieconsent2/3.1.1/cookieconsent.min.js" defer></script>
            <script>
                window.addEventListener("load", function(){
                    window.cookieconsent.initialise({
                        "palette": {
                            "popup": {
                            "background": "#efefef",
                            "text": "#404040"
                            },
                            "button": {
                                "background": "#8ec760",
                                "text": "#ffffff"
                            }
                        },
                        "theme": "classic",
                        "content": {
                            "message": "This website uses <a href='https://cookiesandyou.com' target='_blank'>cookies</a> as explained in our <a href='/privacy-policy' target='_blank'>privacy policy</a> notice to offer you a better browsing experience. ",
                            "link": "Learn more...",
                            "dismiss": "Got it!",
                            "href": "https://cookiesandyou.com"
                        }
                    })
                });
            </script>
        <?php
        //}
        ?>

    </body>
    <!-- END: Body-->

</html>

<?php
    $content = minify_html( ob_get_clean() );
    echo $content;
?>