<?php

    error_reporting(0); // this it to suppress warnings

    unset($CFG);

    global $CFG;

    $CFG = new stdClass();

    $CFG->browser_debug_log = false; // debug logs are written to browser console
    $CFG->server_debug_log = false; // debug logs are to error log on the server

    $CFG->search_service_url = 'http://localhost/asc/server/search_service.php';
    $CFG->keyword_service_url = 'http://localhost/asc/server/keyword_service.php';
    $CFG->geoip_service_url = 'http://localhost/asc/server/geoip_service.php';

    //Production Settings
    //$CFG->search_service_url = 'http://asb-server.rokkada.com/v1/search_service.php';
    //$CFG->keyword_service_url = 'http://asb-server.rokkada.com/v1/keyword_service.php';
    //$CFG->geoip_service_url = 'http://asb-server.rokkada.com/v1/geoip_service.php';

    // asc-ga service
    $CFG->asc_ga_pageview_service_url = 'http://asc-ga.webilify.com/service/ascga_pageviews_service.php?site=cpuk&';
    //$CFG->asc_ga_related_search_service_url = 'http://asc-ga.webilify.com/service/ascga_hybrid_related_search_service.php?site=cpuk&';
    $CFG->asc_ga_related_search_service_url = 'http://asc-ga.webilify.com/service/ascga_slr_mlt_proxy_service.php?site=cpuk';
    
    $CFG->asc_ga_target_countries = array ('WO', 'US', 'GB', 'CA', 'AU', 'IN', 'PH', 'ZA');
    $CFG->show_related_ws = false;
    $CFG->show_related_cp = false; // backend service code for this is not  implemented (Apr 24th 2018)
    $CFG->show_search_suggestion = false;
    $CFG->asc_ga_slr_suggest_service_url = "http://asc-ga.webilify.com/service/ascga_slr_sugg_proxy_service.php?site=cpuk&";

    // v3 download button
    $CFG->show_download_button = true;
    $CFG->download_service_url = '//google.gviewer.net/docs/download?s=lk&';
    
    //$CFG->cdn_domain = "";
    $CFG->cdn_domain = "//colouring-pages.co.uk";
    
 
    $CFG->header_keys = array(
        //'OPENSSL_CONF',
        //'PATH',
        'HTTP_HOST',
        'HTTP_CONNECTION',
        'HTTP_CACHE_CONTROL',
        'HTTP_UPGRADE_INSECURE_REQUESTS',
        'HTTP_USER_AGENT',
        'HTTP_ACCEPT',
        'HTTP_ACCEPT_ENCODING',
        'HTTP_ACCEPT_LANGUAGE',
        'HTTP_COOKIE',
        //'SystemRoot',
        //'COMSPEC',
        //'PATHEXT',
        //'WINDIR',
        //'SERVER_SIGNATURE',
        //'SERVER_SOFTWARE',
        //'SERVER_NAME',
        //'SERVER_ADDR',
        //'SERVER_PORT',
        'REMOTE_ADDR',
        //'DOCUMENT_ROOT',
        //'REQUEST_SCHEME',
        //'CONTEXT_PREFIX',
        //'CONTEXT_DOCUMENT_ROOT',
        //'SERVER_ADMIN',
        //'SCRIPT_FILENAME',
        'REMOTE_PORT',
        //'GATEWAY_INTERFACE',
        //'SERVER_PROTOCOL',
        'REQUEST_METHOD',
        'QUERY_STRING',
        'REQUEST_URI',
        //'SCRIPT_NAME',
        //'PHP_SELF',
        'REQUEST_TIME_FLOAT',
        'REQUEST_TIME',
    );


    if (!function_exists('debug_to_console')) {
        function debug_to_console($data) {
            global $CFG;

            $output = '';
            if (is_array($data)) {

                if ($CFG->browser_debug_log)
                    $output = "<script>console.log( 'Debug: " . http_build_query($data, '', ', ') . "' );</script>";

                if ($CFG->server_debug_log)
                    error_log(print_r($data, TRUE), 0);

            } else {
                if ($CFG->browser_debug_log)
                    $output = "<script>console.log( 'Debug: " . $data . "' );</script>";

                if ($CFG->server_debug_log)
                    error_log($data, 0);
            }
            echo $output;
        }
    }



    $CFG->site_name = "Printable Colouring Pages";
    $CFG->site_url = 'http://colouring-pages.co.uk'; // dev
    //$CFG->site_url = 'https://colouring-pages.co.uk'; // prod
    $CFG->site_type = 'cp';
    $CFG->site_meta_title = 'Home';
    $CFG->site_meta_title_suffix = 'Free Colouring Pages';
    $CFG->site_meta_desc = 'Free Printable Colouring Pages - Search &amp; print thousands of colouring pages. Browse quick-find categories to find your colouring page quickly.';
    $CFG->site_meta_keywords = 'Free, Colouring,, Alphabet, Animals, Birthday, Boys, Buildings, Cartoons, Countries, Fantasy, Food, Girls, Holidays, Months, Music, Nature, People, Sports, Toys, Transportation, why coloring, learn colors, mix colors, india, cricket, ganesha, krishna, diwali, rama, sita, ravana, lakshmama, gandhiji, rangoli, god, godess, bike, scooter, car, etc ';

    $CFG->site_content_json = 'data/cpuk-content.json';
    $CFG->old_search_param = 'show'; // for existing site search url param

    $CFG->search_box_placeholder = 'Enter colouring page...'; // used in search form input
    $CFG->no_results_message = 'Oops...no colouring pages found.  Check & try again with correct colouring page name.'; // used in sresults.php

    $CFG->site_search_uri = $CFG->site_url.'/colouring/';
    $CFG->invalid_search_url = $CFG->site_url.'/invalid-colouring-pages'; // this to match key in data json
    $CFG->unauth_search_url = $CFG->site_url.'/invalid-colouring-pages'; // this to match key in data json
    
    $CFG->search_input_maxlength = 60;
    $CFG->wscp_name_max_length = 60; // this is to control long invalid, junk names fed into the system
    
    // this is for managing local search history
    $CFG->hconfig = array(
        "id" => "cpuk",
        "path" => "C:\bing-cache\client\cpuk.sync",
        //"path" => "/home/indiael1/public_html/sites/v1/hcache/cpuk.sync", //production
        "size" => "15"
    );

    // whether to show social locker or not
    $CFG->show_locker = false; // switched off on 15th feb 2018 to study the impact
    
    $CFG->eu_countries = array('BE', 'BG', 'CZ', 'DK', 'DE', 'EE', 'IE', 'EL', 'ES', 'FR', 'HR', 'IT', 'CY', 'LV', 'LT', 'LU', 'HU', 'MT', 'NL', 'AT', 'PL', 'PT', 'RO', 'SI', 'SK', 'FI', 'SE', 'UK');

    // ads script
    $CFG->g_ad_top_banner = '<script async src="//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
                                        <!-- CPUK_RES_TOP -->
                                        <ins class="adsbygoogle"
                                             style="display:block"
                                             data-ad-client="ca-pub-6997161217503277"
                                             data-ad-slot="8627604421"
                                             data-ad-format="auto"></ins>
                                        <script>
                                            (adsbygoogle = window.adsbygoogle || []).push({});
                                        </script>';
                                        
    $CFG->g_ad_search_right = '<script async src="//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
                                        <!-- CPUK_RES_TOP -->
                                        <ins class="adsbygoogle"
                                             style="display:block"
                                             data-ad-client="ca-pub-6997161217503277"
                                             data-ad-slot="8627604421"
                                             data-ad-format="auto"></ins>
                                        <script>
                                            (adsbygoogle = window.adsbygoogle || []).push({});
                                        </script>';

    $CFG->g_ad_body_main = '<script async src="//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
                                        <!-- CPUK_RES_MAIN -->
                                        <ins class="adsbygoogle"
                                             style="display:block"
                                             data-ad-client="ca-pub-6997161217503277"
                                             data-ad-slot="2860272422"
                                             data-ad-format="auto"></ins>
                                        <script>
                                        (adsbygoogle = window.adsbygoogle || []).push({});
                                        </script>';

    $CFG->g_ad_body_right = '<script async src="//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
                                        <!-- CPUK_RES_RIGHT -->
                                        <ins class="adsbygoogle"
                                             style="display:block"
                                             data-ad-client="ca-pub-6997161217503277"
                                             data-ad-slot="7508353623"
                                             data-ad-format="auto"></ins>
                                        <script>
                                        (adsbygoogle = window.adsbygoogle || []).push({});
                                        </script>';

    $CFG->g_page_ad_script = '<script async src="//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
                                            <script>
                                            (adsbygoogle = window.adsbygoogle || []).push({
                                                google_ad_client: "ca-pub-6997161217503277",
                                                enable_page_level_ads: true
                                              });
                                            </script>'; // this is inserted in the header to enable page level ads for mobile
    // end of ad script

    // g analytics script
    $CFG->g_analytics_script = ''; /*<!-- Global site tag (gtag.js) - Google Analytics -->
                                <script async src="https://www.googletagmanager.com/gtag/js?id=UA-29690185-1"></script>
                                <script>
                                    window.dataLayer = window.dataLayer || [];
                                    function gtag(){dataLayer.push(arguments);}
                                    gtag(\'js\', new Date());

                                    gtag(\'config\', \'UA-29690185-1\');
                                </script>';
                                * 
                                */
    // end of g analytics script

?>