<?php

	include 'client/minifier.php';
    ob_start();

?>

<?php


    require_once 'client/bingc.lib.php';
    include 'config.php';

    global $CFG;

    $request_type = ""; // used in decide on the include page
    $page_title = $CFG->site_meta_title;
    $page_desc = $CFG->site_meta_desc;
    $page_keywords = $CFG->site_meta_keywords;
    $page_desc = $CFG->site_meta_desc;

    $content_title = '';
    $content_html = '';
    $response = '';

    $history = '';

    // add to history
    $bclient = new bingc\client();

    if (isset($_GET[$CFG->old_search_param]) && trim($_GET[$CFG->old_search_param] != '')) { // make sure there is no html or echo before 301 redirect

        debug_to_console("client - keyword is " . $_GET[$CFG->old_search_param]);
        // check if keyword is valid and also get slug to use in the url
        $response = $bclient->check_keyword($_GET[$CFG->old_search_param], $CFG->site_type, $_SERVER['HTTP_HOST']);

        //echo 'log ' . $response['data']['log'];
        debug_to_console($response['data']);

        // check if it is authorised request (query/keyword will be set)
        if(isset($response['data']['query'])) {

            if (!$response['data']['query']['keyword']['is_valid']) {

                debug_to_console('client - keyword is not valid');
                header("Location: $CFG->invalid_search_url");

            } else {

                $url = $CFG->site_search_uri . $response['data']['query']['keyword']['slug'];
                debug_to_console('client - redirect to ' . $url);
                header("HTTP/1.1 301 Moved Permanently");
                header("Location: $url");
            }
        }
        else {
                debug_to_console('client - unauthorised request');
                header("Location: $CFG->unauth_search_url");
        }
    }
    else if (isset($_GET['s'])) {  // this param is set in .htaccess file as part of url rewrite

        $request_type = 'search'; // include
        //echo '[s-condition]keyword: ' . $_GET['s']."<br>";

        $response = $bclient->get($_GET['s'], $CFG->site_type, $_SERVER['HTTP_HOST']);

        //echo $response['data']['log'];
		debug_to_console('client - logging entire response');
		debug_to_console($response);

        if (isset($response['data']['results'])) {
            debug_to_console($response['data']['results']);
        }
		debug_to_console('client - 1');

        // check if it is authorised request (query/keyword will be set)
        if(isset($response['data']['query'])) {

            if (!$response['data']['query']['keyword']['is_valid']) {
                debug_to_console('client - keyword is not valid');
                header("Location: $CFG->invalid_search_url");

            } else {
				debug_to_console('client - 2 else');
                $page_title = $response['data']['query']['keyword']['title_text'].' Worksheets';
                $page_desc = $response['data']['query']['keyword']['title_text'];
                $page_keywords = $response['data']['query']['keyword']['clean_text'];
                $content_title = $response['data']['query']['keyword']['title_text'];
				debug_to_console('client - 3 else before add history');
                $bclient->add_to_history($response['data']['query']['keyword']['title_text'].'|'.$response['data']['query']['keyword']['slug']);
				debug_to_console('client - 4 else end');
            }
        }
        else {
            debug_to_console('client - unauthorised request');
            header("Location: $CFG->unauth_search_url");
        }

    }
    else if (isset($_GET['p'])) { // this param is set in .htaccess file as part of url rewrite
        $request_type = 'page'; // include content.php
        //echo 'page: ' . $_GET['p'];

        $content = file_get_contents($CFG->site_content_json);
        $cname = $_GET['p'];
        $json_a = json_decode($content, true);
        //var_dump(json_decode($content, true));
        //echo "<script> console.log('".$json_a."');</script>";
        //echo "request name: " . $cname;
        if (isset($json_a['categories'][$cname])) {
            //echo "content name: " . $json_a['categories'][$cname]['title'];
            $page_title = $json_a['categories'][$cname]['title'];
            $page_desc = $json_a['categories'][$cname]['title'];
            $page_keywords = $json_a['categories'][$cname]['title'];

            $content_title = $json_a['categories'][$cname]['title'];
            $content_html = $json_a['categories'][$cname]['html'];
        }
        else {
            //echo "<script> console.log('client - content data not found');</script>";
            debug_to_console('client - unauthorised request');
            header("Location: $CFG->unauth_search_url");

        }
    }
	else if (isset($_GET['nc_p'])) {

		$request_type = 'nc';

		$nc_p = $_GET['nc_p'];
		$nc_l = $_GET['nc_l'];
		$nc_k = $_GET['nc_k'];
		$nc_y = $_GET['nc_y'];
		$nc_s = $_GET['nc_s'];

		//$nc_p = 'home';
		$page_title = 'National Curriculum ' . ucfirst($nc_l) . ' ' . str_replace('-', ' ', ucfirst($nc_k)) . ' ' . str_replace('-', ' ', ucfirst($nc_y)) . ' ' . ucfirst(str_replace('-', ' ', $nc_s));
		$page_desc = $page_title;
		$page_keywords = 'national curriculum, ' . $nc_l . ', ' . $nc_k . ', ' . $nc_y . ', ' . $nc_s;
	}
    else {
        $request_type = '';
    }

	// this code is for getting geo info (country) for a given client ip (used for displaying sb ads)
	// IMPORTANT - this code does not return data for local IP (local testing)
	$geo_info = $bclient->get_geoip_info($_SERVER['REMOTE_ADDR'], $CFG->site_type, $_SERVER['HTTP_HOST']);

	// for testing
	//$geo_info = $bclient->get_geoip_info('43.224.158.176', 'cp', $_SERVER['HTTP_HOST']);

	//echo $geo_info['data']['log'];
	//debug_to_console($geo_info['data']);

?>



<!DOCTYPE html>
<html lang="en">
	<head>
		<title><?php echo $page_title.' - '. $CFG->site_meta_title_suffix; ?></title>
        <base href="<?php echo $CFG->site_url; ?>" />
        <meta http-equiv="content-type" content="text/html; charset=utf-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="keywords" content="<?php echo $page_keywords; ?>" />
        <meta name="author" content="teacherworksheets.co.uk" />
        <meta name="description" content="<?php echo $page_desc; ?>" />
        <link href="favicon.ico" rel="shortcut icon" type="image/vnd.microsoft.icon" />

		<meta charset="utf-8">
		<meta name = "format-detection" content = "telephone=no" />

		<link rel="icon" href="favicon.ico">
		<link rel="shortcut icon" href="favicon.ico" />
		<?php
		//<link rel="stylesheet" href="/css/owl.carousel.css">

		//<link rel="stylesheet" href="/css/slider.css"> ?>

		<link rel="stylesheet" href="css/pandalocker.2.1.0.min.css">
		
		<link rel="stylesheet" type="text/css" href="css/jquery.floating-social-share.min.css" />

		<link rel="stylesheet" href="/css/uknc.css">
		<link rel="stylesheet" href="/css/superfish.css">
		<link rel="stylesheet" href="/css/style.css">


		<script src="/js/jquery.js"></script>
		<script src="/js/jquery-migrate-1.1.1.js"></script>
		<script src="/js/script.js"></script>
		<script src="/js/jquery.ui.totop.js"></script>
		<script src="/js/superfish.js"></script>
		<script src="/js/jquery.equalheights.js"></script>
		<script src="/js/jquery.mobilemenu.js"></script>
		<script src="/js/jquery.easing.1.3.js"></script>
		<?php /*
		<script src="/js/owl.carousel.js"></script>
		<script src="/js/jquery.flexslider-min.js"></script>
		<script src="/js/kwiks.js"></script>
		*/ ?>

		<?php /*
		<script>
			$(document).ready(function(){
				$().UItoTop({ easingType: 'easeOutQuart' });
				var owl = $("#owl");
				owl.owlCarousel({
					items : 4, //10 items above 1000px browser width
					itemsDesktop : [995,3], //5 items between 1000px and 901px
					itemsDesktopSmall : [767, 2], // betweem 900px and 601px
					itemsTablet: [700, 2], //2 items between 600 and 0
					itemsMobile : [479, 1], // itemsMobile disabled - inherit from itemsTablet option
					navigation : true,
				});
			})
			var Main = Main || {};
			jQuery(window).load(function() {
				window.responsiveFlag = jQuery('#responsiveFlag').css('display');
				Main.gallery = new Gallery();
				jQuery(window).resize(function() {
					Main.gallery.update();
				});
			});
			function Gallery(){
				var self = this,
					container = jQuery('.flexslider'),
					clone = container.clone( false );
					this.init = function (){
						if( responsiveFlag == 'block' ){
						var slides = container.find('.slides');
						slides.kwicks({
							max : 500,
							spacing : 0
						}).find('li > a').click(function (){
							return false;
						});
						} else {
							container.flexslider();
						}
					}
					this.update = function () {
						var currentState = jQuery('#responsiveFlag').css('display');
						if(responsiveFlag != currentState) {
							responsiveFlag = currentState;
							container.replaceWith(clone);
							container = clone;
							clone = container.clone( false );
							this.init();
						}
					}
				this.init();
			}
		</script>
		*/ ?>

		<!--[if lt IE 8]>
		<div style=' clear: both; text-align:center; position: relative;'>
			<a href="https://windows.microsoft.com/en-US/internet-explorer/products/ie/home?ocid=ie6_countdown_bannercode">
				<img src="https://storage.ie6countdown.com/assets/100/images/banners/warning_bar_0000_us.jpg" border="0" height="42" width="820" alt="You are using an outdated browser. For a faster, safer browsing experience, upgrade for free today." />
			</a>
		</div>
		<![endif]-->
		<!--[if lt IE 9]>
		<script src="js/html5shiv.js"></script>
		<link rel="stylesheet" media="screen" href="css/ie.css">
		<![endif]-->

        <?php echo $CFG->g_analytics_script; ?>
        <?php echo $CFG->g_page_ad_script; ?>

		<script type="text/javascript" src="js/pandalocker.2.1.0.min.js"></script>

		<script>
			jQuery(document).ready(function ($) {
				$('.to-lock').sociallocker({
					theme: 'dandyish',
					overlap:{
						mode: 'blurring',
						intensity: '5'
					},
					buttons:{
						order: ["facebook-like","google-plus"],
						counters: true,
						lazy: false
					},
					facebook: { like: { url: "https://teacherworksheets.co.uk" } },
					google: { plus: { url: "https://teacherworksheets.co.uk" } },
					url: 'https://teacherworksheets.co.uk',
					text: {
						header: 'Like Us To View Worksheets',
						message: 'Like us on facebook or google plus to access free worksheets..thank you.<br/>*In case you don\'t see some worksheets after liking us, please refresh the page.<br/>'
					}
				});
			});
		</script>

	</head>
	<body class="page1" id="top">

<!--==============================header=================================-->
		<header>
			<div class="clear"></div>
			<div class="hmain">
				<div class="container_12"  style="background-color: white;">
					<div class="grid_2"   style="text-align: center;">
							<a href="/" style="width:160px;">
								<img src="logo.png" alt="<?php echo $CFG->site_name ?>">
							</a>
					</div>
					<div class="grid_10">
						<div class="menu_block">
							<nav class="horizontal-nav full-width horizontalNav-notprocessed">
								<ul class="sf-menu">
									<li><a href="/national-curriculum/primary/keystage-1/year-1/english" title="Key Stage 1 Year 1 English">Eng-Y1</a></li>
									<li><a href="/national-curriculum/primary/keystage-1/year-2/english" title="Key Stage 1 Year 2 English">Eng-Y2</a></li>
									<li><a href="/national-curriculum/primary/keystage-2/year-3/english" title="Key Stage 2 Year 3 English">Eng-Y3</a></li>
									<li><a href="/national-curriculum/primary/keystage-2/year-4/english" title="Key Stage 2 Year 4 English">Eng-Y4</a></li>
									<li><a href="/national-curriculum/primary/keystage-2/year-5/english" title="Key Stage 2 Year 5 English">Eng-Y5</a></li>
									<li><a href="/national-curriculum/primary/keystage-2/year-6/english" title="Key Stage 2 Year 6 English">Eng-Y6</a></li>
									<li><a href="/national-curriculum/primary/keystage-1/year-1/mathematics" title="Key Stage 1 Year 1 Mathematics">MAT-Y1</a></li>
									<li><a href="/national-curriculum/primary/keystage-1/year-2/mathematics" title="Key Stage 1 Year 2 Mathematics">MAT-Y2</a></li>
									<li><a href="/national-curriculum/primary/keystage-2/year-3/mathematics" title="Key Stage 2 Year 3 Mathematics">MAT-Y3</a></li>
									<li><a href="/national-curriculum/primary/keystage-2/year-4/mathematics" title="Key Stage 2 Year 4 Mathematics">MAT-Y4</a></li>
									<li><a href="/national-curriculum/primary/keystage-2/year-5/mathematics" title="Key Stage 2 Year 5 Mathematics">MAT-Y5</a></li>
									<li><a href="/national-curriculum/primary/keystage-2/year-6/mathematics" title="Key Stage 2 Year 6 Mathematics">MAT-Y6</a></li>
									<li><a href="/national-curriculum/primary/keystage-1/year-1/science" title="Key Stage 1 Year 1 Science">SCI-Y1</a></li>
									<li><a href="/national-curriculum/primary/keystage-1/year-2/science" title="Key Stage 1 Year 2 Science">SCI-Y2</a></li>
									<li><a href="/national-curriculum/primary/keystage-2/year-3/science" title="Key Stage 2 Year 3 Science">SCI-Y3</a></li>
									<li><a href="/national-curriculum/primary/keystage-2/year-4/science" title="Key Stage 2 Year 4 Science">SCI-Y4</a></li>
									<li><a href="/national-curriculum/primary/keystage-2/year-5/science" title="Key Stage 2 Year 5 Science">SCI-Y5</a></li>
									<li><a href="/national-curriculum/primary/keystage-2/year-6/science" title="Key Stage 2 Year 6 Science">SCI-Y6</a></li>
								</ul>
							</nav>
							<div class="clear"></div>
						</div>
					</div>
						<div class="clear"></div>
				</div>
				<div class="container_12">
					<div class="grid_12" style="text-align: center;">
						<?php echo $CFG->g_ad_top_banner; ?>
					</div>
					<div class="grid_12">
						<div id="search-form">
							<form class="form-container" method="post" action="/client/search">
								<input type="text" class="search-field" name="s" maxlength="50" value="" placeholder="<?php echo $CFG->search_box_placeholder; ?>"/>
								<div class="submit-container">
									<input type="submit" value="" class="submit" />

								</div>
							</form>
							<div>
								<?php
								$hlinks = $bclient->get_history_links();
								$hlinks = str_replace($CFG->site_url, '', $hlinks);
								//debug_to_console($hlinks);
								echo $hlinks;
								?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</header>
		<div class="main">
<!--==============================Content=================================-->
			<div class="content">
				<div class="container_12">
					<?php
						if($request_type === 'search') {
							include 'includes/sresults.php';
						}
						else if($request_type === 'page') {
							include 'includes/content.php';
						}
						else if($request_type === 'nc') {
							include 'includes/nc_content.php';
						}
						else {
                            //echo "redirecting to home";
							include 'includes/home.php';
						}
					?>
				</div>
			</div>
<!--==============================footer=================================-->
			<?php include "footer.php"; ?>
		</div>
		<script type="text/javascript" src="js/jquery.floating-social-share.min.js"></script>
		<script>
			<?php /*
			$("body").floatingSocialShare({
				buttons: ["facebook", "twitter", "google-plus"],
				text: "share with:"
			});
			 */ ?>

			$(".content").floatingSocialShare({
				buttons: [
					"facebook", "google-plus", "twitter", "pinterest", "reddit", "whatsapp"
				],
				text: {'default': 'share with: ', 'facebook': 'share with facebook', 'google-plus': 'share with g+'},
				text_title_case: true,
				twitter_counter: false,
				popup: false,
				place: "content-right"
			});

		</script>
     </body>
</html>

<?php
$content = minify_html( ob_get_clean() );

echo $content;
?>