<?php

	//uncomment below line in production
	ini_set("include_path", '/home/indiael1/php:' . ini_get("include_path") );

    require_once "Mail.php";

	require_once '../../client/bingc.lib.php';
	include '../../config.php';

	global $CFG;

	if($_POST)
	{
		require('constant.php');

		debug_to_console('inside contact.php');

		$user_name      = filter_var($_POST["name"], FILTER_SANITIZE_STRING);
		$user_email     = filter_var($_POST["email"], FILTER_SANITIZE_EMAIL);
		$user_country      = filter_var($_POST["country"], FILTER_SANITIZE_STRING);
		//$user_phone     = filter_var($_POST["phone"], FILTER_SANITIZE_STRING);
		$content   = filter_var($_POST["content"], FILTER_SANITIZE_STRING);

		$gcip = filter_var($_POST["gcip"], FILTER_SANITIZE_STRING);
		$gciso = filter_var($_POST["gciso"], FILTER_SANITIZE_STRING);
		$gcname = filter_var($_POST["gcname"], FILTER_SANITIZE_STRING);

		if(empty($user_name)) {
			$empty[] = "<b>Name</b>";
		}
		if(empty($user_email)) {
			$empty[] = "<b>Email</b>";
		}
		if(empty($user_country)) {
			$empty[] = "<b>Country</b>";
		}
		/*if(empty($user_phone)) {
			$empty[] = "<b>Phone Number</b>";
		}*/
		if(empty($content)) {
			$empty[] = "<b>Comments</b>";
		}

		if(!empty($empty)) {
			$output = json_encode(array('type'=>'error', 'text' => implode(", ",$empty) . ' Required!'));
			die($output);
		}

		if(!filter_var($user_email, FILTER_VALIDATE_EMAIL)){ //email validation
			$output = json_encode(array('type'=>'error', 'text' => '<b>'.$user_email.'</b> is an invalid Email, please correct it.'));
			die($output);
		}

		//reCAPTCHA validation
		if (isset($_POST['g-recaptcha-response'])) {

			require('component/recaptcha/src/autoload.php');

			$recaptcha = new \ReCaptcha\ReCaptcha(SECRET_KEY, new \ReCaptcha\RequestMethod\SocketPost());

			$resp = $recaptcha->verify($_POST['g-recaptcha-response'], $_SERVER['REMOTE_ADDR']);

			  if (!$resp->isSuccess()) {
					$output = json_encode(array('type'=>'error', 'text' => '<b>Captcha</b> Validation Required!'));
					die($output);
			  }
		}

		$toEmail = $CFG->contactus_to_email;

		$mailHeaders = "From: " . $user_name . "<" . $user_email . ">\r\n";


		$headers = array(
				'MIME-Version' => '1.0',
				'Content-type' => 'text/html; charset=iso-8859-1',
				'From' => "From: " . $user_name . "<" . $user_email . ">",
				'To' => $toEmail,
				'Subject' => $CFG->contactus_subject
		);

		$body = '<p>Name: ' . $user_name . '</p>';
		$body .= '<p>Email: ' . $user_email . '</p>';
		$body .= '<p>Country: ' . $user_country . '</p>';
		$body .= '<p>Comments: ' . $content . '</p>';
		$body .= '<p>Geo IP: ' . $gcip . '</p>';
		$body .= '<p>Geo ISO: ' . $gciso . '</p>';
		$body .= '<p>Geo Country: ' . $gcname . '</p>';

		debug_to_console('header');
		debug_to_console($CFG->smtpcfg);

		$smtp = Mail::factory('smtp', $CFG->smtpcfg);
		debug_to_console('sending mail');

		// Send the mail
		$mail = $smtp->send($toEmail, $headers, $body);

		debug_to_console($mail .'->mail sent');

		if ($mail) {
			$output = json_encode(array('type'=>'message', 'text' => '<div class="alert alert-success" role="alert">Hi '.$user_name .', thank you for contacting us. We will get back to you shortly.</div>'));
			die($output);
		} else {
			$output = json_encode(array('type'=>'error', 'text' => '<div class="alert alert-warning" role="alert">Unable to send email, please try again later.</div>'));
			die($output);
		}
	}