<div class="row py-2">
    <?php
    // display common core home page
    if ($cc_page === 'home') {
        debug_to_console('cc - home');
    ?>
        <!-- Center Column -->
        <div class="col-sm-8">
            <article class="col-xs-12 mb-2">
                <h1><?php echo $page_title; ?></h1>
                <p class="lead">
                    Common Core State Standards Initiative is a an educational initiative in United States that details what K-12 students should know in the English & Language Arts and Mathematics at the end of each grade.
                </p>
                <div  class="row">
                    <div class="col-sm-12">
                        <h6 class="text-secondary">There are five key components to the standards for English and Language Arts (ELA). They are -</h6>
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item py-1">Reading (R)</li>
                            <li class="list-group-item py-1">Writing (W)</li>
                            <li class="list-group-item py-1">Speaking and Listening (SL)</li>
                            <li class="list-group-item py-1">Language (L)</li>
                            <li class="list-group-item py-1">Media & Technology (MT)</li>
                        </ul>
                        <blockquote class="font-italic">In ELA, common core standard code contains 3 parts separated by dots (key component, grade & topic). For e.g., L.1.1 means Language - Grade 1 - Topic 1 (Conventions of Standard English).
                        </blockquote>
                    </div>
                    <div class="col-sm-12">
                        <div class="card border border-light mb-2">
                            <div class="card-header bg-white border-bottom border-warning">ELA</div>
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item py-1"><a href="/common-core/ela/kindergarten" title="Common Core ELA Kindergarten">Kindergarten</a></li>
                                <li class="list-group-item py-1"><a href="/common-core/ela/grade-1" title="Common Core ELA Grade 1">Grade 1</a></li>
                                <li class="list-group-item py-1"><a href="/common-core/ela/grade-2" title="Common Core ELA Grade 2">Grade 2</a></li>
                                <li class="list-group-item py-1"><a href="/common-core/ela/grade-3" title="Common Core ELA Grade 3">Grade 3</a></li>
                                <li class="list-group-item py-1"><a href="/common-core/ela/grade-4" title="Common Core ELA Grade 4">Grade 4</a></li>
                                <li class="list-group-item py-1"><a href="/common-core/ela/grade-5" title="Common Core ELA Grade 5">Grade 5</a></li>
                                <li class="list-group-item py-1"><a href="/common-core/ela/grade-6" title="Common Core ELA Grade 6">Grade 6</a></li>
                                <li class="list-group-item py-1"><a href="/common-core/ela/grade-7" title="Common Core ELA Grade 7">Grade 7</a></li>
                                <li class="list-group-item py-1"><a href="/common-core/ela/grade-8" title="Common Core ELA Grade 8">Grade 8</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div  class="row">
                    <div class="col-sm-12">
                        <h6  class="text-secondary">There are 11 key components to the standards for Mathematics (Math) from Kindergarten to grade 8 -</h6>
                        <ul class="list-group  list-group-flush col-sm-8 py-1">
                            <li class="list-group-item py-1">Counting & Cardinality (CC)</li>
                            <li class="list-group-item py-1">Operations & Algebraic Thinking (OA)</li>
                            <li class="list-group-item py-1">Numbers and Operations in Base 10 (MBT)</li>
                            <li class="list-group-item py-1">Measurement & Data (MD)</li>
                            <li class="list-group-item py-1">Geometry (G)</li>
                            <li class="list-group-item py-1">Numbers & Operations - Fractions (NF)</li>
                            <li class="list-group-item py-1">Ratios And Proportional Relationships (RP)</li>
                            <li class="list-group-item py-1">The Number System (NS)</li>
                            <li class="list-group-item py-1">Expressions & Equations (EE)</li>
                            <li class="list-group-item py-1">Statistics And Probability (SP)</li>
                            <li class="list-group-item py-1">Functions (F)</li>
                        </ul>
                        <blockquote class="font-italic">In Mathematics, common core standard code contains 3 parts separated by dots (grade, key component & topic). For e.g., 1.G.1 means Grade 1 - Geometry - Topic 1 (Reason With Shapes And Their Attributes).
                        </blockquote>
                    </div>
                    <div class="col-sm-12">
                        <div class="card border border-light mb-2">
                            <div class="card-header bg-white border-bottom border-warning">Math</div>
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item py-1"><a href="/common-core/math/kindergarten" title="Common Core Math Kindergarten">Kindergarten</a></li>
                                <li class="list-group-item py-1"><a href="/common-core/math/grade-1" title="Common Core Math Grade 1">Grade 1</a></li>
                                <li class="list-group-item py-1"><a href="/common-core/math/grade-2" title="Common Core Math Grade 2">Grade 2</a></li>
                                <li class="list-group-item py-1"><a href="/common-core/math/grade-3" title="Common Core Math Grade 3">Grade 3</a></li>
                                <li class="list-group-item py-1"><a href="/common-core/math/grade-4" title="Common Core Math Grade 4">Grade 4</a></li>
                                <li class="list-group-item py-1"><a href="/common-core/math/grade-5" title="Common Core Math Grade 5">Grade 5</a></li>
                                <li class="list-group-item py-1"><a href="/common-core/math/grade-6" title="Common Core Math Grade 6">Grade 6</a></li>
                                <li class="list-group-item py-1"><a href="/common-core/math/grade-7" title="Common Core Math Grade 7">Grade 7</a></li>
                                <li class="list-group-item py-1"><a href="/common-core/math/grade-8" title="Common Core Math Grade 8">Grade 8</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </article>
        </div><!--/Center Column-->
        <!-- Right Column -->
        <div class="col-sm-4">
            <div class="card border border-light mb-2">
                <div class="card-header bg-white text-secondary border-bottom border-warning1">Reference Curriculum <span class="badge border border-success text-warning">New!</span></div>
                <ul class="list-group list-group-flush">
                    <li class="list-group-item py-1"><span><img src="<?php echo $CFG->cdn_domain; ?>/images/cflags/au.png" height="14" alt="au"></span> <a href="/curriculum/australia"  title="Australian F10 Curriculum Worksheets">Australian F10</a></li>
                    <li class="list-group-item py-1"><span><img src="<?php echo $CFG->cdn_domain; ?>/images/cflags/ca.png" height="14" alt="ca"></span> <a href="/curriculum/canada" title="Canada Elementary Worksheets">Canada Elementary</a></li>
                    <li class="list-group-item py-1"><span><img src="<?php echo $CFG->cdn_domain; ?>/images/cflags/za.png" height="14" alt="za"></span> <a href="/curriculum/south-africa" title="South African Primary Curriculum Worksheets">South African Primary</a></li>
                    <li class="list-group-item py-1"><span><img src="<?php echo $CFG->cdn_domain; ?>/images/cflags/gb.png" height="14" alt="gb"></span> <a href="/curriculum/uk" title="UK England Primary Worksheets">UK England Primary</a></li>
                    <li class="list-group-item py-1"><span><img src="<?php echo $CFG->cdn_domain; ?>/images/cflags/us.png" height="14" alt="us"></span> <a href="/common-core" title="Common Core Worksheets">US Common Core</a></li>
                </ul>
            </div>
            <div class="card border border-light mb-2">
                <?php echo $CFG->g_ad_body_right; ?>
            </div>
            <?php
            // below 2 params are accessed in pageview include file
            $json_key = 'ascga_pw_pageviews_last7days_wo'; // ascga_pw_pageviews_last7days_wo
            $card_title = 'Top Categories (last 7 days)';
            $dataset = 'categories';
            include __DIR__ . '/ga_pageviews.php';
            ?>
        </div><!--/Right Column -->
    <?php
    }
    // display all topics for the grade
    else if (isset($cc_grade) && !isset($cc_id)) {
        debug_to_console('cc  grade - '. $cc_grade);

        $pattern = '';
        if ($cc_domain === 'ela') {
            //echo 'ela domain';
            // in ela, grade is in the middle part of code
            $pattern = '/.'.($cc_grade === 'kindergarten' ? 'k' : substr($cc_grade, 6)).'../';
        }
        else { // math
            //echo 'math domain';
            // in math, grade is in the first part of code
            $pattern = '/^'.($cc_grade === 'kindergarten' ? 'k' : substr($cc_grade, 6)).'./';
        }

        //echo $pattern;
        //var_dump($cc_json_a[$cc_domain]);

        //get topics in the grade based the pattern
        $grade_topics = $bclient->preg_grep_keys($pattern, $cc_json_a[$cc_domain]);
        // get topic keys
        $grade_topic_keys = array_keys($grade_topics);
        //var_dump($grade_topic_keys);

    ?>
        <div class="col-sm-8">
            <article class="col-xs-12 mb-2">
                <h1><?php echo 'Common Core ' . $cc_domain_t . ' ' . $cc_grade_t ?></h1>
                <p class="lead">Browse through the list of common core standards for <?php echo '<strong>' . ucfirst($cc_grade) . ' ' . $cc_domain_t . '</strong>'; ?>.
                Click on the common core topic title to view all available worksheets.</p>
                <?php
                    //echo 'ccd: ' . $_GET['d'] .  ' id: ' . $_GET['id'] .  ' curriculum: ' . $_GET['cu'];
                ?>
                <?php
                // display all topics in a grade
                echo '<ul class="list-group  list-group-flush">';
                foreach($grade_topics as $i => $item) {
                    //echo '<li><a href="/common-core/'. $cc_domain . '/' . $cc_grade . '/' . $i .'" title="' . ucfirst($cc_grade) . ' ' . $cc_domain . ' ' . $i .'">['.$i.']&nbsp;&nbsp;' . $item['curriculum'] . '</a></li>';
                    echo '<li class="list-group-item flex-column align-items-start"><a href="/common-core/'. $item['slug'] . '" title="' . $cc_grade_t . ' ' . $cc_domain_t . ' ' . $i .'"><h6 class="mb-1">[' . $i .']&nbsp;&nbsp;' . $item['curriculum'] . '</h6></a>';
                    //echo '<div class="text3" style="text-align: right;"><a href="/common-core/' . $item['slug'] . '" title="Common Core ' . $item['page_title'].'"><b>View Worksheets >></b></a></div>';
                    //echo '<p>' . $item['curriculum'] . '</p>';
                    echo '<p class="mb-1">' . $item['detail'] . '</p></li>';
                }
                echo '</ul>';
                ?>
            </article>
            <nav aria-label="Page navigation pwcontent">
                <ul class="pagination justify-content-end">
                    <li class="page-item">
                        <a class="page-link" href="javascript: history.back();">Back</a>
                    </li>
                </ul>
            </nav>
        </div><!--/Center Column-->
        <!-- Right Column -->
        <div class="col-sm-4">
            <div class="card border border-light mb-2">
                <div class="card-header bg-white text-secondary border-bottom border-warning">Reference Curriculum <span class="badge border border-success text-warning">New!</span></div>
                <ul class="list-group list-group-flush">
                    <li class="list-group-item py-1"><span><img src="<?php echo $CFG->cdn_domain; ?>/images/cflags/au.png" height="14" alt="au"></span> <a href="/curriculum/australia"  title="Australian F10 Curriculum Worksheets">Australian F10</a></li>
                    <li class="list-group-item py-1"><span><img src="<?php echo $CFG->cdn_domain; ?>/images/cflags/ca.png" height="14" alt="ca"></span> <a href="/curriculum/canada" title="Canada Elementary Worksheets">Canada Elementary</a></li>
                    <li class="list-group-item py-1"><span><img src="<?php echo $CFG->cdn_domain; ?>/images/cflags/za.png" height="14" alt="za"></span> <a href="/curriculum/south-africa" title="South African Primary Curriculum Worksheets">South African Primary</a></li>
                    <li class="list-group-item py-1"><span><img src="<?php echo $CFG->cdn_domain; ?>/images/cflags/gb.png" height="14" alt="gb"></span> <a href="/curriculum/uk" title="UK England Primary Worksheets">UK England Primary</a></li>
                    <li class="list-group-item py-1"><span><img src="<?php echo $CFG->cdn_domain; ?>/images/cflags/us.png" height="14" alt="us"></span> <a href="/common-core" title="Common Core Worksheets">US Common Core</a></li>
                </ul>
            </div>
            <div class="card border border-light mb-2">
                <?php echo $CFG->g_ad_body_right; ?>
            </div>
            <div class="card border border-light mb-2">
                <div class="card-header bg-white border-bottom border-warning">Math</div>
                <ul class="list-group list-group-flush">
                    <li class="list-group-item py-1"><a href="/common-core/math/kindergarten" title="Common Core Math Kindergarten">Kindergarten</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/math/grade-1" title="Common Core Math Grade 1">Grade 1</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/math/grade-2" title="Common Core Math Grade 2">Grade 2</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/math/grade-3" title="Common Core Math Grade 3">Grade 3</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/math/grade-4" title="Common Core Math Grade 4">Grade 4</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/math/grade-5" title="Common Core Math Grade 5">Grade 5</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/math/grade-6" title="Common Core Math Grade 6">Grade 6</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/math/grade-7" title="Common Core Math Grade 7">Grade 7</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/math/grade-8" title="Common Core Math Grade 8">Grade 8</a></li>
                </ul>
            </div>
            <div class="card border border-light mb-2">
                <div class="card-header bg-white border-bottom border-warning">ELA</div>
                <ul class="list-group list-group-flush">
                    <li class="list-group-item py-1"><a href="/common-core/ela/kindergarten" title="Common Core ELA Kindergarten">Kindergarten</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/ela/grade-1" title="Common Core ELA Grade 1">Grade 1</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/ela/grade-2" title="Common Core ELA Grade 2">Grade 2</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/ela/grade-3" title="Common Core ELA Grade 3">Grade 3</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/ela/grade-4" title="Common Core ELA Grade 4">Grade 4</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/ela/grade-5" title="Common Core ELA Grade 5">Grade 5</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/ela/grade-6" title="Common Core ELA Grade 6">Grade 6</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/ela/grade-7" title="Common Core ELA Grade 7">Grade 7</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/ela/grade-8" title="Common Core ELA Grade 8">Grade 8</a></li>
                </ul>
            </div>
            <?php
                // below 2 params are accessed in pageview include file
                $json_key = 'ascga_pw_pageviews_last7days_wo'; // ascga_pw_pageviews_last7days_wo
                $card_title = 'Top Categories (last 7 days)';
                $dataset = 'categories';
                include __DIR__ . '/ga_pageviews.php';
            ?>
        </div><!--/Right Column -->
    <?php
    }
    // display all worksheets for the cc id
    else if (isset($cc_id)) {
        debug_to_console('cc  id - '. $cc_id);
        $topic = $cc_json_a[$cc_domain][$cc_id];
        //var_dump($topic);
    ?>

        <!-- Center Column -->
        <div class="col-sm-8">
            <article class="col-xs-12 mb-2">
                <h1><?php echo 'Common Core ' . $cc_domain_t . ' ' . $cc_grade_t . ' '. $cc_id ?></h1>
                <p class="lead"><?php echo '<strong>' . $topic['curriculum'] . '</strong>'; ?></p>
                <p class="lead"><?php echo $topic['detail']; ?>
                    <?php
                    // display worksheet links
                    if (count($topic['ws']) > 0) {
                        echo '<h5 class="text-secondary">Click on the link to view all available worksheets related to the concept.</h5>';
                        echo '<ul class="list-group list-group-flush">';
                        foreach ($topic['ws'] as $i => $item) {
                            echo '<li class="list-group-item py-1"><span class="fa fa-file-pdf-o pr-1"></span><a href="/worksheet/' . $item['ws_slug'] . '" title="' . $item['ws_title'] . '">' . $item['ws_title'] . '</a></li>';
                        }
                        echo '</ul>';
                    } else {
                        echo '<div class="alert alert-warning" role="alert">Sorry! No worksheets found for this topic.</div>';
                    }
                    ?>
            </article>
            <nav aria-label="Page navigation pwcontent">
                <ul class="pagination justify-content-end">
                    <li class="page-item">
                        <a class="page-link" href="javascript: history.back();">Back</a>
                    </li>
                </ul>
            </nav>
        </div><!--/Center Column-->
        <!-- Right Column -->
        <div class="col-sm-4">
            <div class="card border border-light mb-2">
                <div class="card-header bg-white border-bottom border-warning">Reference Curriculum <span class="badge border border-success text-warning">New!</span></div>
                <ul class="list-group list-group-flush">
                    <li class="list-group-item py-1"><span><img src="<?php echo $CFG->cdn_domain; ?>/images/cflags/au.png" height="14" alt="au"></span> <a href="/curriculum/australia"  title="Australian F10 Curriculum Worksheets">Australian F10</a></li>
                    <li class="list-group-item py-1"><span><img src="<?php echo $CFG->cdn_domain; ?>/images/cflags/ca.png" height="14" alt="ca"></span> <a href="/curriculum/canada" title="Canada Elementary Worksheets">Canada Elementary</a></li>
                    <li class="list-group-item py-1"><span><img src="<?php echo $CFG->cdn_domain; ?>/images/cflags/za.png" height="14" alt="za"></span> <a href="/curriculum/south-africa" title="South African Primary Curriculum Worksheets">South African Primary</a></li>
                    <li class="list-group-item py-1"><span><img src="<?php echo $CFG->cdn_domain; ?>/images/cflags/gb.png" height="14" alt="gb"></span> <a href="/curriculum/uk" title="UK England Primary Worksheets">UK England Primary</a></li>
                    <li class="list-group-item py-1"><span><img src="<?php echo $CFG->cdn_domain; ?>/images/cflags/us.png" height="14" alt="us"></span> <a href="/common-core" title="Common Core Worksheets">US Common Core</a></li>
                </ul>
            </div>
            <div class="card border border-light mb-2">
                <?php echo $CFG->g_ad_body_right; ?>
            </div>
            <div class="card border border-light mb-2">
                <div class="card-header bg-white border-bottom border-warning">Math</div>
                <ul class="list-group list-group-flush">
                    <li class="list-group-item py-1"><a href="/common-core/math/kindergarten" title="Common Core Math Kindergarten">Kindergarten</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/math/grade-1" title="Common Core Math Grade 1">Grade 1</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/math/grade-2" title="Common Core Math Grade 2">Grade 2</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/math/grade-3" title="Common Core Math Grade 3">Grade 3</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/math/grade-4" title="Common Core Math Grade 4">Grade 4</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/math/grade-5" title="Common Core Math Grade 5">Grade 5</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/math/grade-6" title="Common Core Math Grade 6">Grade 6</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/math/grade-7" title="Common Core Math Grade 7">Grade 7</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/math/grade-8" title="Common Core Math Grade 8">Grade 8</a></li>
                </ul>
            </div>
            <div class="card border border-light mb-2">
                <div class="card-header bg-white border-bottom border-warning">ELA</div>
                <ul class="list-group list-group-flush">
                    <li class="list-group-item py-1"><a href="/common-core/ela/kindergarten" title="Common Core ELA Kindergarten">Kindergarten</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/ela/grade-1" title="Common Core ELA Grade 1">Grade 1</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/ela/grade-2" title="Common Core ELA Grade 2">Grade 2</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/ela/grade-3" title="Common Core ELA Grade 3">Grade 3</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/ela/grade-4" title="Common Core ELA Grade 4">Grade 4</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/ela/grade-5" title="Common Core ELA Grade 5">Grade 5</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/ela/grade-6" title="Common Core ELA Grade 6">Grade 6</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/ela/grade-7" title="Common Core ELA Grade 7">Grade 7</a></li>
                    <li class="list-group-item py-1"><a href="/common-core/ela/grade-8" title="Common Core ELA Grade 8">Grade 8</a></li>
                </ul>
            </div>
            <?php
                // below 2 params are accessed in pageview include file
                $json_key = 'ascga_pw_pageviews_last7days_wo'; // ascga_pw_pageviews_last7days_wo
                $card_title = 'Top Categories (last 7 days)';
                $dataset = 'categories';
                include __DIR__ . '/ga_pageviews.php';
            ?>
        </div><!--/Right Column -->
        <?php
    }
    ?>
</div><!--/row -->