<?php

	include 'client/minifier.php';
    ob_start();

?>

<?php


    require_once 'client/bingc.lib.php';
    include 'config.php';

    global $CFG;

    $request_type = ""; // used in decide on the include page
    $page_title = $CFG->site_meta_title;
    $page_desc = $CFG->site_meta_desc;
    $page_keywords = $CFG->site_meta_keywords;
    $page_desc = $CFG->site_meta_desc;

    $content_title = '';
    $content_html = '';
    $response = '';

    $history = '';

    // add to history
    $bclient = new bingc\client();

	/* ***** 302 redirect is disabled to ensure little impact to search urls; instead using below if blog to process old url param requests as them are without redirecting
    if (isset($_GET[$CFG->old_search_param]) && trim($_GET[$CFG->old_search_param] != '')) { // make sure there is no html or echo before 301 redirect

        debug_to_console("client - keyword is " . $_GET[$CFG->old_search_param]);
        // check if keyword is valid and also get slug to use in the url
        $response = $bclient->check_keyword($_GET[$CFG->old_search_param], $CFG->site_type, $_SERVER['HTTP_HOST']);

        //echo 'log ' . $response['data']['log'];
        debug_to_console($response['data']);

        // check if it is authorised request (query/keyword will be set)
        if(isset($response['data']['query'])) {

            if (!$response['data']['query']['keyword']['is_valid']) {

                debug_to_console('client - keyword is not valid');
                header("Location: $CFG->invalid_search_url");

            } else {

                $url = $CFG->site_search_uri . $response['data']['query']['keyword']['slug'];
                debug_to_console('client - redirect to ' . $url);
                header("HTTP/1.1 301 Moved Permanently");
                header("Location: $url");
            }
        }
        else {
                debug_to_console('client - unauthorised request');
                header("Location: $CFG->unauth_search_url");
        }
    }
	*/
	if (isset($_GET[$CFG->old_search_param]) && trim($_GET[$CFG->old_search_param] != '')) {  // THIS condition to bypass 302 redirect commented above (temporary)

		$request_type = 'search'; // include

		$response = $bclient->get($_GET[$CFG->old_search_param], $CFG->site_type, $_SERVER['HTTP_HOST']);

		echo $response['data']['log'];
		debug_to_console('client - logging entire response');
		debug_to_console($response);

		if (isset($response['data']['results'])) {
			debug_to_console($response['data']['results']);
		}
		debug_to_console('client - 1');

		// check if it is authorised request (query/keyword will be set)
		if(isset($response['data']['query'])) {

			if (!$response['data']['query']['keyword']['is_valid']) {
				debug_to_console('client - keyword is not valid');
				header("Location: $CFG->invalid_search_url");

			} else {
				debug_to_console('client - 2 else');
				$page_title = $response['data']['query']['keyword']['title_text'].' Worksheets';
				$page_desc = $response['data']['query']['keyword']['title_text'];
				$page_keywords = $response['data']['query']['keyword']['clean_text'];
				$content_title = $response['data']['query']['keyword']['title_text'];
				debug_to_console('client - 3 else before add history');
				$bclient->add_to_history($response['data']['query']['keyword']['title_text'].'|'.$response['data']['query']['keyword']['slug']);
				debug_to_console('client - 4 else end');
			}
		}
		else {
			debug_to_console('client - unauthorised request');
			header("Location: $CFG->unauth_search_url");
		}
	}
    else if (isset($_GET['s'])) {  // this param is set in .htaccess file as part of url rewrite

        $request_type = 'search'; // include
        //echo '[s-condition]keyword: ' . $_GET['s']."<br>";

        $response = $bclient->get($_GET['s'], $CFG->site_type, $_SERVER['HTTP_HOST']);

        echo $response['data']['log'];
		debug_to_console('client - logging entire response');
		debug_to_console($response);

        if (isset($response['data']['results'])) {
            debug_to_console($response['data']['results']);
        }
		debug_to_console('client - 1');

        // check if it is authorised request (query/keyword will be set)
        if(isset($response['data']['query'])) {

            if (!$response['data']['query']['keyword']['is_valid']) {
                debug_to_console('client - keyword is not valid');
                header("Location: $CFG->invalid_search_url");

            } else {
				debug_to_console('client - 2 else');
                $page_title = $response['data']['query']['keyword']['title_text'].' Worksheets';
                $page_desc = $response['data']['query']['keyword']['title_text'];
                $page_keywords = $response['data']['query']['keyword']['clean_text'];
                $content_title = $response['data']['query']['keyword']['title_text'];
				debug_to_console('client - 3 else before add history');
                $bclient->add_to_history($response['data']['query']['keyword']['title_text'].'|'.$response['data']['query']['keyword']['slug']);
				debug_to_console('client - 4 else end');
            }
        }
        else {
            debug_to_console('client - unauthorised request');
            header("Location: $CFG->unauth_search_url");
        }

    }
    else if (isset($_GET['p'])) { // this param is set in .htaccess file as part of url rewrite
        $request_type = 'page'; // include content.php
        //echo 'page: ' . $_GET['p'];

        $content = file_get_contents($CFG->site_content_json);
        $cname = $_GET['p'];
        $json_a = json_decode($content, true);
        //var_dump(json_decode($content, true));
        //echo "<script> console.log('".$json_a."');</script>";
        //echo "request name: " . $cname;
        if (isset($json_a['categories'][$cname])) {
            //echo "content name: " . $json_a['categories'][$cname]['title'];
            $page_title = $json_a['categories'][$cname]['title'];
            $page_desc = $json_a['categories'][$cname]['title'];
            $page_keywords = $json_a['categories'][$cname]['title'];

            $content_title = $json_a['categories'][$cname]['title'];
            $content_html = $json_a['categories'][$cname]['html'];
        }
        else {
            debug_to_console('client - content data not found');
            debug_to_console('client - unauthorised request');
            header("Location: $CFG->unauth_search_url");
        }
    }
    else if (isset($_GET['ccd'])) { // this param is set in .htaccess file as part of url rewrite

        debug_to_console('ccd:'. $_GET['ccd'] .' id:'. $_GET['id'] .'curriculum:'. $_GET['cu']);
        //common core home
		$request_type = 'cc'; // include cc_content.php
        $cc_page = 'home'; // display main landing page for common core

        $cc_domain = $_GET['ccd'];
        $cc_grade = $_GET['g'];
        $cc_id = $_GET['id'];
        $cc_cu = $_GET['cu'];

		$cc_content = '';
        if ($cc_domain === 'ela') {
        	$cc_content = file_get_contents($CFG->cc_ela_content_json);

			/* this code is to remove special (non text) characters. It is not required as of now
			for ($i = 0; $i <= 31; ++$i) {
				$cc_content = str_replace(chr($i), "", $cc_content);
			}
			$cc_content = str_replace(chr(127), "", $cc_content);

			if(0 === strpos(bin2hex($cc_content), 'efbbbf')) {
				$cc_content = substr($cc_content, 3);
			}
			*/
			//$cc_content = str_replace("\t", "", str_replace("\n", "", $cc_content));
			//$cc_content = stripslashes(html_entity_decode($cc_content));
			//$cc_content = preg_replace('/[\x00-\x1F\x80-\xFF]/', '', $cc_content, true);
			//$cc_content = trim($cc_content);
			//$cc_content = str_replace('&quot;', '"',$cc_content);

        } else if ($cc_domain === 'math') {
            $cc_content = file_get_contents($CFG->cc_math_content_json);
        }

        $cc_json_a = json_decode($cc_content, true);
		//echo json_last_error_msg(); // used only for debugging json

        //var_dump($cc_json_a); // DO NOT ENABLE...IT CAUSES WHITE PAGE

        //debug_to_console($cc_json_a); // DO NOT ENABLE...IT CAUSES WHITE PAGE

        if ($cc_domain === 'home') {
            $cc_page ='home';
            $page_title = 'Common Core Home';
            $page_desc = 'Worksheets based on US Common Core standards';
            $page_keywords = 'common core, us, curriculum, ela, math, english, literature, arts';
        }
        else if (in_array($cc_domain, array('ela', 'math')) && isset($cc_grade)) {
            $cc_page ='grade';
            $page_title = 'Common Core '.strtoupper($cc_domain).' '.str_replace('-', ' ', ucfirst($cc_grade)); // 15th dec 2016 google seo - replacing - with space
            $page_desc = 'Common Core '.strtoupper($cc_domain).' '.str_replace('-', ' ', ucfirst($cc_grade)); // 15th dec 2016 google seo - replacing - with space
            $page_keywords = $cc_grade.', common core, us, curriculum, ela, math, english, literature, arts';
        }
        else if (in_array($cc_domain, array('ela', 'math')) && isset($cc_id)) {
            $cc_page ='id';
            $topic = $cc_json_a[$cc_domain][$cc_id];
            $page_title = 'Common Core '.$topic['page_title'];
            
            $page_title = str_replace('-', '', $page_title); // 15th dec 2016 google seo - replacing - with nothing
            $page_title = str_replace('/', '', $page_title); // 15th dec 2016 google seo - replacing / with nothing
            $page_title = str_replace(':', '', $page_title); // 15th dec 2016 google seo - replacing : with nothing
            
            $page_desc = 'Common Core '.$page_title; // 15th dec 2016 google seo - using clean page_title
            $page_keywords = $cc_id.', '.str_replace('-', ', ', $cc_cu).', common core, us, curriculum, ela, math, english, literature, arts';
        }
	else {
		debug_to_console('client - unauthorised request');
		header("Location: $CFG->unauth_search_url");
	}
    }
    else {
        $request_type = '';
    }
    
    // this code is for getting geo info (country) for a given client ip (used for displaying sb ads)
    // IMPORTANT - this code does not return data for local IP (local testing)
    $geo_info = $bclient->get_geoip_info($_SERVER['REMOTE_ADDR'], $CFG->site_type, $_SERVER['HTTP_HOST']);
    
    // for testing
    //$geo_info = $bclient->get_geoip_info('43.224.158.176', 'cp', $_SERVER['HTTP_HOST']);
     
    //echo $geo_info['data']['log'];
    //debug_to_console($geo_info['data']);    

?>



<!DOCTYPE html>
<html lang="en">
	<head>
		<title><?php echo $page_title.' - '. $CFG->site_meta_title_suffix; ?></title>
        <base href="<?php echo $CFG->site_url; ?>" />
        <meta http-equiv="content-type" content="text/html; charset=utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="keywords" content="<?php echo $page_keywords; ?>" />
        <meta name="author" content="PCP" />
        <meta name="description" content="<?php echo $page_desc; ?>" />
        <link href="favicon.ico" rel="shortcut icon" type="image/vnd.microsoft.icon" />

		<meta charset="utf-8">
		<meta name = "format-detection" content = "telephone=no" />

		<link rel="icon" href="favicon.ico">
		<link rel="shortcut icon" href="favicon.ico" />
		<?php
		 //<link rel="stylesheet" href="/css/owl.carousel.css">
		 //<link rel="stylesheet" href="/css/slider.css">
		?>
		<link rel="stylesheet" href="css/pandalocker.2.1.0.min.css">

		<link rel="stylesheet" href="/css/style.css">

		<script src="/js/jquery.js"></script>
		<script src="/js/jquery-migrate-1.1.1.js"></script>
		<script src="/js/script.js"></script>
		<script src="/js/jquery.ui.totop.js"></script>
		<script src="/js/superfish.js"></script>
		<script src="/js/jquery.equalheights.js"></script>
		<script src="/js/jquery.mobilemenu.js"></script>
		<script src="/js/jquery.easing.1.3.js"></script>
		<script src="/js/owl.carousel.js"></script>
		<script src="/js/jquery.flexslider-min.js"></script>
		<script src="/js/kwiks.js"></script>


		<script>
			$(document).ready(function(){
				$().UItoTop({ easingType: 'easeOutQuart' });
				var owl = $("#owl");
				owl.owlCarousel({
					items : 4, //10 items above 1000px browser width
					itemsDesktop : [995,3], //5 items between 1000px and 901px
					itemsDesktopSmall : [767, 2], // betweem 900px and 601px
					itemsTablet: [700, 2], //2 items between 600 and 0
					itemsMobile : [479, 1], // itemsMobile disabled - inherit from itemsTablet option
					navigation : true,
				});
			})
			var Main = Main || {};
			jQuery(window).load(function() {
				window.responsiveFlag = jQuery('#responsiveFlag').css('display');
				Main.gallery = new Gallery();
				jQuery(window).resize(function() {
					Main.gallery.update();
				});
			});
			function Gallery(){
				var self = this,
					container = jQuery('.flexslider'),
					clone = container.clone( false );
					this.init = function (){
						if( responsiveFlag == 'block' ){
						var slides = container.find('.slides');
						slides.kwicks({
							max : 500,
							spacing : 0
						}).find('li > a').click(function (){
							return false;
						});
						} else {
							container.flexslider();
						}
					}
					this.update = function () {
						var currentState = jQuery('#responsiveFlag').css('display');
						if(responsiveFlag != currentState) {
							responsiveFlag = currentState;
							container.replaceWith(clone);
							container = clone;
							clone = container.clone( false );
							this.init();
						}
					}
				this.init();
			}
		</script>

		<!--[if lt IE 8]>
		<div style=' clear: both; text-align:center; position: relative;'>
			<a href="http://windows.microsoft.com/en-US/internet-explorer/products/ie/home?ocid=ie6_countdown_bannercode">
				<img src="http://storage.ie6countdown.com/assets/100/images/banners/warning_bar_0000_us.jpg" border="0" height="42" width="820" alt="You are using an outdated browser. For a faster, safer browsing experience, upgrade for free today." />
			</a>
		</div>
		<![endif]-->
		<!--[if lt IE 9]>
		<script src="js/html5shiv.js"></script>
		<link rel="stylesheet" media="screen" href="css/ie.css">
		<![endif]-->

        <?php echo $CFG->g_analytics_script; ?>
        <?php echo $CFG->g_page_ad_script; ?>

		<script type="text/javascript" src="js/pandalocker.2.1.0.min.js"></script>
		
		
		<?php
			// added mar 8th 2017. hide social locker for US & other high cpc countries
		
               		if (!(in_array($geo_info['data']['country_iso'], $CFG->slocker_hide_countries))) {
               ?>
			<script>
				jQuery(document).ready(function ($) {
					$('.to-lock').sociallocker({
						theme: 'dandyish',
						overlap:{
							mode: 'blurring',
							intensity: '5'
						},
						buttons:{
							order: ["facebook-like","google-plus"],
							counters: true,
							lazy: false
						},
						facebook: { like: { url: "http://printableworksheets.in" } },
						google: { plus: { url: "http://printableworksheets.in" } },
						url: 'http://printableworksheets.in',
						text: {
							header: 'Like us to view worksheets',
							message: 'Like us once on facebook or google plus to access free worksheets..thank you.<br/>*In case you don\'t see some worksheets after liking us, please refresh the page.<br/>'
						}
					});
				});
			</script>
	       <?php	
			} 
               ?>
               		
	</head>
	<body class="page1" id="top">

<!--==============================header=================================-->
		<header>
			<div class="clear"></div>
			<?php /* banner ad. not used
			<div class="container_12">
				<div class="grid_12" style="text-align: center;">
					<?php echo $CFG->g_ad_top_banner; ?>
				</div>
				<div class="clear"></div>
			</div>
            		*/
			?>
			<div class="container_12">
				<div class="grid_12" style="text-align: center;">
					<a href="/" style="width:160px; align-self: center">
						<img src="logo.png" alt="<?php echo $CFG->site_name ?>" style="height:60px;">
					</a>
				</div>
				<div class="grid_12">
					<div class="menu_block">
						<nav class="horizontal-nav full-width horizontalNav-notprocessed">
							<ul class="sf-menu">
								<li><a href="/">Home</a></li>
								<li><a href="/math-worksheets">Math</a></li>
								<li><a href="/science-worksheets">Science</a></li>
								<li><a href="/grammar-worksheets">Grammar</a></li>
								<li><a href="/phonics-worksheets">Phonics</a></li>
								<li><a href="/read-write-worksheets">Read / Write</a></li>
								<li><a href="/kindergarten-worksheets">Kindergarten</a></li>
							</ul>
						</nav>
					</div>
				</div>
				<div class="clear"></div>
			</div>
			<div class="container_12">
				<div class="grid_6">
					<div class="block_header">
					<div class="title">Search</div>
					<div class="pad">
					<div id="search-form">
						<form class="form-container" method="post" action="/client/search">
							<input type="text" class="search-field" name="s" maxlength="50" value="" placeholder="<?php echo $CFG->search_box_placeholder; ?>"/>
							<div class="submit-container">
								<input type="submit" value="" class="submit" />

							</div>
						</form>
					</div>

                    <div class="text3" style="align-content: center;"><b><p>Search History</p></b></div>

					<div>
                        <?php echo $bclient->get_history_links(); ?>
                    </div>
					</div>
					</div>
					<span id="responsiveFlag"></span>
				</div>
				<div class="grid_6" >
					<div class="block_header">
					<div class="title">Sponsored Links</div>
                    <div class="pad">
                        <?php echo $CFG->g_ad_search_right; ?>
                    </div>
					</div>
				</div>
			</div>
		</header>
		<div class="main">
<!--==============================Content=================================-->
			<div class="content">
				<div class="container_12">
					<?php
						if($request_type === 'search') {
							include 'includes/sresults.php';
						}
						else if($request_type === 'page') {
							include 'includes/content.php';
						}
						else if($request_type === 'cc') {
							include 'includes/cc_content.php';
						}
						else {
                            				//echo "redirecting to home";
							include 'includes/home.php';
						}
					?>
				</div>
			</div>
<!--==============================footer=================================-->
			<?php include "footer.php"; ?>
		</div>
     </body>
</html>

<?php
$content = minify_html( ob_get_clean() );

echo $content;
?>