<div class="clear"></div>
<div class="container_12">

    <?php
    // display common core home page
    if ($cc_page === 'home') {
        debug_to_console('cc - home');
    ?>
        <div class="grid_12">
            <div class="block2">
                <div class="title"><?php echo $page_title; ?></div>
                <div class="pad">
                <p>
                    Common Core State Standards Initiative is a an educational initiative in United States that details what K-12 students should know in the English & Language Arts and Mathematics at the end of each grade.
                </p>
                <p>
                    <b>There are five key components to the standards for English and Language Arts (ELA). They are -</b>
                </p>
                <ul class="list">
                    <li>Reading (R)</li>
                    <li>Writing (W)</li>
                    <li>Speaking and Listening (SL)</li>
                    <li>Language (L)</li>
                    <li>Media & Technology (MT)</li>
                </ul>
                <p></p>
                <p>In ELA, common core standard code contains 3 parts separated by dots (key component, grade & topic). For e.g., L.1.1 means Language - Grade 1 - Topic 1 (Conventions of Standard English).
                </p>
                <p></p>
                <p>
                    <b>There are 11 key components to the standards for Mathematics (MATH) from Kindergarten to grade 8. They are -</b>
                </p>
                <ul class="list">
                    <li>Counting & Cardinality (CC)</li>
                    <li>Operations & Algebraic Thinking (OA)</li>
                    <li>Numbers and Operations in Base 10 (MBT)</li>
                    <li>Measurement & Data (MD)</li>
                    <li>Geometry (G)</li>
                    <li>Numbers & Operations - Fractions (NF)</li>
                    <li>Ratios And Proportional Relationships (RP)</li>
                    <li>The Number System (NS)</li>
                    <li>Expressions & Equations (EE)</li>
                    <li>Statistics And Probability (SP)</li>
                    <li>Functions (F)</li>
                </ul>
                <p></p>
                <p>In Mathematics, common core standard code contains 3 parts separated by dots (grade, key component & topic). For e.g., 1.G.1 means Grade 1 - Geometry - Topic 1 (Reason With Shapes And Their Attributes).
                </p>
                <p></p>
                </div>
            </div>
        </div>
        <div class="grid_4">
            <div class="block2 maxheight">
                <div class="title">MATH</div>
                <div class="pad">
                    <ul class="list">
                        <li><a href="/common-core/math/kindergarten" title="Common Core MATH Kindergarten">Kindergarten</a></li>
                        <li><a href="/common-core/math/grade-1" title="Common Core MATH Grade-1">Grade 1</a></li>
                        <li><a href="/common-core/math/grade-2" title="Common Core MATH Grade-2">Grade 2</a></li>
                        <li><a href="/common-core/math/grade-3" title="Common Core MATH Grade-3">Grade 3</a></li>
                        <li><a href="/common-core/math/grade-4" title="Common Core MATH Grade-4">Grade 4</a></li>
                        <li><a href="/common-core/math/grade-5" title="Common Core MATH Grade-5">Grade 5</a></li>
                        <li><a href="/common-core/math/grade-6" title="Common Core MATH Grade-6">Grade 6</a></li>
                        <li><a href="/common-core/math/grade-7" title="Common Core MATH Grade-7">Grade 7</a></li>
                        <li><a href="/common-core/math/grade-8" title="Common Core MATH Grade-8">Grade 8</a></li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="grid_4">
            <div class="block2 maxheight">
                <div class="title">ELA</div>
                <div class="pad">
                    <ul class="list">
                        <li><a href="/common-core/ela/kindergarten" title="Common Core ELA Kindergarten">Kindergarten</a></li>
                        <li><a href="/common-core/ela/grade-1" title="Common Core ELA Grade-1">Grade 1</a></li>
                        <li><a href="/common-core/ela/grade-2" title="Common Core ELA Grade-2">Grade 2</a></li>
                        <li><a href="/common-core/ela/grade-3" title="Common Core ELA Grade-3">Grade 3</a></li>
                        <li><a href="/common-core/ela/grade-4" title="Common Core ELA Grade-4">Grade 4</a></li>
                        <li><a href="/common-core/ela/grade-5" title="Common Core ELA Grade-5">Grade 5</a></li>
                        <li><a href="/common-core/ela/grade-6" title="Common Core ELA Grade-6">Grade 6</a></li>
                        <li><a href="/common-core/ela/grade-7" title="Common Core ELA Grade-7">Grade 7</a></li>
                        <li><a href="/common-core/ela/grade-8" title="Common Core ELA Grade-8">Grade 8</a></li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="grid_4">
            <div class="block2 maxheight" style="height: 263px;">
                <div class="box_inner">
                    <?php echo $CFG->g_ad_body_right; ?>
                </div>
            </div>
        </div>
        <div class="clear"></div>
    <?php
    }
    // display all topics for the grade
    else if (isset($cc_grade)) {
        debug_to_console('cc  grade - '. $cc_grade);

        $pattern = '';
        if ($cc_domain === 'ela') {
            //echo 'ela domain';
            // in ela, grade is in the middle part of code
            $pattern = '/.'.($cc_grade === 'kindergarten' ? 'k' : substr($cc_grade, 6)).'../';
        }
        else { // math
            //echo 'math domain';
            // in math, grade is in the first part of code
            $pattern = '/^'.($cc_grade === 'kindergarten' ? 'k' : substr($cc_grade, 6)).'./';
        }

        //echo $pattern;
        //var_dump($cc_json_a[$cc_domain]);

        //get topics in the grade based the pattern
        $grade_topics = $bclient->preg_grep_keys($pattern, $cc_json_a[$cc_domain]);
        // get topic keys
        $grade_topic_keys = array_keys($grade_topics);
        //var_dump($grade_topic_keys);

        /* this is not used..meant to fetch particular category of topics within grade
        $grade_topic_codes = array();
        foreach($grade_topic_keys as $i => $item) {
            $grade_topic_codes[$i] = explode('.',$item)[1];
        }
        $grade_topic_codes = array_unique(array_values($grade_topic_codes));
        */
    ?>

        <div class="grid_8">
            <div class="block2">
                <div class="title"><?php echo 'COMMON CORE : '.strtoupper($cc_domain).' : '.strtoupper($cc_grade) ?></div>
                <div class="pad">
                    <p>Below is the list of common core standards for this grade.</p>
                    <p>Click on the common core standard or 'view worksheets' link to view all available worksheets in for the topic.</p>
                    <?php //echo 'ccd: ' . $_GET['d'] .  ' id: ' . $_GET['id'] .  ' curriculum: ' . $_GET['cu'];
                    ?>
                </div>
                <div class="title"><?php echo '<a style="float: left; margin-left: 5px;" href="/common-core"><< CC Home</a>&nbsp;'; ?></div>
            </div>
    <?php
            // display all topics in a grade
            foreach($grade_topics as $i => $item) {
    ?>
                <div class="block_header">
                    <div class="title"><?php echo '<a href="/common-core/'.$item['slug'].'" title="Common Core '.$item['page_title'].'">'.$i.'</a>'; ?></div>
                    <div class="pad">
                        <p><?php echo $item['curriculum']; ?></p>
                        <p><?php echo $item['detail']; ?></p>
                        <div class="text3" style="text-align: right;"><?php echo '<a href="/common-core/'.$item['slug'].'" title="Common Core '.$item['page_title'].'"><b>View Worksheets >></b>'; ?></div>
                    </div>
                </div>
    <?php
            }
    ?>
        </div>
        <div class="grid_4">
            <div class="block2 maxheight" style="height: 263px;">
                <div class="box_inner">
                    <?php echo $CFG->g_ad_body_right; ?>
                </div>
            </div>
        </div>
        <div class="clear"></div>
    <?php
    }
    // display all worksheets for the cc id
    else if (isset($cc_id)) {
        debug_to_console('cc  id - '. $cc_id);
        $topic = $cc_json_a[$cc_domain][$cc_id];
        //var_dump($topic);
        ?>

        <div class="grid_8">
            <div class="block2">
                <div class="title"><?php echo 'COMMON CORE : '.strtoupper($cc_domain).' : '.strtoupper($cc_id) ?></div>
                <div class="pad">
                    <p><?php echo $topic['curriculum']; ?></p>
                    <p><?php echo $topic['detail']; ?>
                    <p></p>
                </div>
                <div class="title"><?php echo '<a style="float: left; margin-left: 5px;" href="/common-core">CC Home</a>&nbsp;<a style="float: right; margin-right: 5px;"href="javascript: history.back();"><< Back</a>'; ?></div>
            </div>
            <div class="block_header">
                <div class="title"><?php echo '<a href="/common-core/'.$topic['slug'].'" title="'.$topic['page_title'].'">'.$cc_id.' - Worksheets</a>'; ?></div>
                <div class="pad">

                <?php
                    // display worksheet links
                    if (count($topic['ws']) > 0) {
                        echo '<p><br>Click on the link to view all available worksheets related to the title.</p>';
                        echo '<ul class="list">';
                        foreach ($topic['ws'] as $i => $item) {
                            echo '<li><a href="/worksheet/' . $item['ws_slug'] . '">' . $item['ws_title'] . '</a></li>';
                        }
                        echo '</ul>';
                    } else {
                        echo '<p><br>Sorry...no worksheets available at this time for this topic.</p>';
                    }
                ?>

                </div>
                <p></p>
                <div class="title"><?php echo '<a style="float: left; margin-left: 5px;" href="/common-core">CC Home</a>&nbsp;<a style="float: right; margin-right: 5px;"href="javascript: history.back();"><< Back</a>'; ?></div>
            </div>
        </div>

        <div class="grid_4">
            <div class="block2 maxheight" style="height: 263px;">
                <div class="box_inner">
                    <?php echo $CFG->g_ad_body_right; ?>
                </div>
            </div>
        </div>
        <div class="clear"></div>
    <?php
    }
    ?>
</div>