<?php
/**
 * Created by PhpStorm.
 * User: Man
 * Date: 28-06-2016
 * Time: 11:08 AM
 */

namespace bingc;

include_once dirname(__DIR__).'/config.php';

use Fuz\Component\SharedMemory\Storage\StorageFile;
use Fuz\Component\SharedMemory\SharedMemory;


class client
{
    function __construct()
    {

    }

    // main method for websites to call to get ws, cp results
    public function get($keyword, $stype = 'ws', $site) {

        debug_to_console('client - inside get method');
        debug_to_console('keyword - '. urldecode($keyword));
        global $CFG;

        $url = $CFG->search_service_url;
        $headers = $this->get_header_data();

        $data = array('kw' => $keyword, 'stype'=>$stype, 'site'=>$site, 'headers' => $headers);

        debug_to_console($headers);

        // use key 'http' even if you send the request to https://...
        $options = array(
            'http' => array(
                'request_fulluri' => true,
                'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
                "Accept-Encoding: gzip\r\n",
                'method'  => 'POST',
                // ignore_errors can help debug – remove for production. This option added in PHP 5.2.10
                'ignore_errors' => false,
                'content' => http_build_query($data)
            )
        );

        $context  = stream_context_create($options);
        $response = file_get_contents($url, 0, $context);

        if ($response === FALSE) {
            /* Handle error */
        }
        $fresponse = $this->format_response($response);
        return $fresponse;
    }


    // method to check if keyword is valid
    public function check_keyword($keyword, $stype = 'ws', $site) {

        debug_to_console('client - inside check_keyword method');
        debug_to_console('keyword - '. urldecode($keyword));
        global $CFG;

        $url = $CFG->keyword_service_url;
        $headers = $this->get_header_data();

        $data = array('kw' => $keyword, 'stype'=>$stype, 'site'=>$site, 'headers' => $headers);

        debug_to_console($headers);

        // use key 'http' even if you send the request to https://...
        $options = array(
            'http' => array(
                'request_fulluri' => true,
                'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
                "Accept-Encoding: gzip\r\n",
                'method'  => 'POST',
                // ignore_errors can help debug – remove for production. This option added in PHP 5.2.10
                'ignore_errors' => false,
                'content' => http_build_query($data)
            )
        );

        $context  = stream_context_create($options);
        $response = file_get_contents($url, 0, $context);

        if ($response === FALSE) {
            /* Handle error */
        }
        $fresponse = $this->format_response($response);
        return $fresponse;
    }
    
    
    // method to geo location info based on http header remote ip
    public function get_geoip_info($ip, $stype = 'ws', $site) {

        debug_to_console('client - inside get_geoip_info method');
        debug_to_console('ip - '. $ip);
        global $CFG;

        $url = $CFG->geoip_service_url;
        $headers = $this->get_header_data();

        $data = array('ip' => $ip, 'stype'=>$stype, 'site'=>$site, 'headers' => $headers);

        debug_to_console($headers);

        // use key 'http' even if you send the request to https://...
        $options = array(
            'http' => array(
                'request_fulluri' => true,
                'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
                "Accept-Encoding: gzip\r\n",
                'method'  => 'POST',
                // ignore_errors can help debug – remove for production. This option added in PHP 5.2.10
                'ignore_errors' => false,
                'content' => http_build_query($data)
            )
        );

        $context  = stream_context_create($options);
        $response = file_get_contents($url, 0, $context);

        if ($response === FALSE) {
            /* Handle error */
        }
        $fresponse = $this->format_response($response);
        return $fresponse;
    }
    


    // this function separates debug scripts from json results & returns array
    private function format_response($response) {

        $js = "";
        $result = "";

        preg_match_all('#<script(.*?)</script>#is', $response, $matches);

        foreach ($matches[0] as $value) {
            $js .= $value;
        }

        $result = preg_replace('#<script(.*?)</script>#is', '', $response);
        $result = json_decode($result, true);
        $result['data']['log'] = $js;
        //print_r($result);

        return $result;
    }


    private function get_header_data($header_name = null)
    {
        global $CFG;
        $keys = array_keys($_SERVER);
        //print_r($keys);
        debug_to_console('remote address - '. $_SERVER['REMOTE_ADDR']);


        if (is_null($header_name)) {
            $headers = preg_grep("/^HTTP_(.*)/si", $keys);
        } else {
            $header_name_safe = str_replace("-", "_", strtoupper(preg_quote($header_name)));
            $headers = preg_grep("/^HTTP_${header_name_safe}$/si", $keys);
            //using header keys defined in config file
        }

        $headers = $CFG->header_keys;
        $headervals = null;
        foreach ($headers as $header) {
            if (is_null($header_name)) {
                //$headervals[substr($header, 5)] = $_SERVER[$header];
                $headervals[$header] = isset($_SERVER[$header])? $_SERVER[$header] : '';
            } else {
                return $_SERVER[$header];
            }
        }
        return $headervals;
    }

    private function get_domain_name() {
        return $_SERVER['SERVER_NAME'];
    }

    // updates history with new search keyword & save it the shared file
    public function add_to_history($keyword)
    {
        global $CFG;
        debug_to_console('client - inside add to history');
        $storage = new StorageFile($CFG->hconfig['path']);
        debug_to_console('client - storage file path '. $CFG->hconfig['path']);
        $sm = new SharedMemory($storage);
        debug_to_console('client - 10');
        if(!$sm->{$CFG->hconfig['id']}) {
            debug_to_console('client - 11');
            $history = array($keyword);
            $sm->{$CFG->hconfig['id']} = $history;
            debug_to_console('client - 11-end');
        }
        else {
            debug_to_console('client - 12');
            $history = $sm->{$CFG->hconfig['id']};
            debug_to_console('client - 13');
            // remove same keyword already existing in history
            $history = array_diff($history, array($keyword));

            while (count($history) > $CFG->hconfig['size']) {
                array_pop($history);
            }
            debug_to_console('client - 14');
            array_unshift($history, $keyword);
            $sm->{$CFG->hconfig['id']} = $history;
            debug_to_console('client - 15');
        }
        debug_to_console('client - 16');
        return $sm->{$CFG->hconfig['id']};
    }

    // returns search history
    public function get_history()
    {
        global $CFG;

        $storage = new StorageFile($CFG->hconfig['path']);

        $sm = new SharedMemory($storage);

        return $sm->{$CFG->hconfig['id']};
    }

    // returns search history
    public function get_history_links()
    {
        global $CFG;

        $history = $this->get_history();
        $links = '<p>';
        foreach ($history as $item) {
            $links = $links.'<a href="'.$CFG->site_search_uri.explode('|', $item)[1].'">'.explode('|', $item)[0].'</a> | ';
        }
        $links = $links.'</p>';
        return $links;
    }


    /**
     * Get's the current "pretty" URI from the URL.  It will also correct the QUERY_STRING server var and the $_GET array.
     * It supports all forms of mod_rewrite and the following forms of URL:
     *
     * http://example.com/index.php/foo (returns '/foo')
     * http://example.com/index.php?/foo (returns '/foo')
     * http://example.com/index.php/foo?baz=bar (returns '/foo')
     * http://example.com/index.php?/foo?baz=bar (returns '/foo')
     *
     * Similarly using mod_rewrite to remove index.php:
     * http://example.com/foo (returns '/foo')
     * http://example.com/foo?baz=bar (returns '/foo')
     *
     * @author      Dan Horrigan <http://dhorrigan.com>
     * @copyright   Dan Horrigan
     * @license     MIT License <http://www.opensource.org/licenses/mit-license.php>
     * @param   bool    $prefix_slash   whether to return the uri with a '/' in front
     * @return  string  the uri
     */
    function get_keyword_from_url($prefix_slash = false)

    {
        if (isset($_SERVER['PATH_INFO']))
        {
            $uri = $_SERVER['PATH_INFO'];
        }
        elseif (isset($_SERVER['REQUEST_URI']))
        {
            $uri = $_SERVER['REQUEST_URI'];

            if (strpos($uri, $_SERVER['SCRIPT_NAME']) === 0)
            {
                $uri = substr($uri, strlen($_SERVER['SCRIPT_NAME']));
            }
            elseif (strpos($uri, dirname($_SERVER['SCRIPT_NAME'])) === 0)
            {
                $uri = substr($uri, strlen(dirname($_SERVER['SCRIPT_NAME'])));
            }

            // This section ensures that even on servers that require the URI to be in the query string (Nginx) a correct
            // URI is found, and also fixes the QUERY_STRING server var and $_GET array.
            if (strncmp($uri, '?/', 2) === 0)
            {
                $uri = substr($uri, 2);
            }
            $parts = preg_split('#\?#i', $uri, 2);
            $uri = $parts[0];
            if (isset($parts[1]))
            {
                $_SERVER['QUERY_STRING'] = $parts[1];
                parse_str($_SERVER['QUERY_STRING'], $_GET);
            }
            else
            {
                $_SERVER['QUERY_STRING'] = '';
                $_GET = array();
            }
            $uri = parse_url($uri, PHP_URL_PATH);
        }
        else
        {
            // Couldn't determine the URI, so just return false
            return false;
        }

        // Do some final cleaning of the URI and return it
        $uri = ($prefix_slash ? '/' : '').str_replace(array('//', '../'), '/', trim($uri, '/'));
        //remove  fixed string /worksheets/
        $uri =  substr($uri, 12);
        // check for / & .php to eliminate junk keywords (added Aug 20th 2013)
        if (preg_match ('![^a-z0-9-% ]!i', $uri) === 0)
        {
            return urldecode($uri);
        }
        else {
            return false;
        }

    }

    // code to redirect page
    function movePage($num,$url)
    {
        static $http = array(
            100 => "HTTP/1.1 100 Continue",
            101 => "HTTP/1.1 101 Switching Protocols",
            200 => "HTTP/1.1 200 OK",
            201 => "HTTP/1.1 201 Created",
            202 => "HTTP/1.1 202 Accepted",
            203 => "HTTP/1.1 203 Non-Authoritative Information",
            204 => "HTTP/1.1 204 No Content",
            205 => "HTTP/1.1 205 Reset Content",
            206 => "HTTP/1.1 206 Partial Content",
            300 => "HTTP/1.1 300 Multiple Choices",
            301 => "HTTP/1.1 301 Moved Permanently",
            302 => "HTTP/1.1 302 Found",
            303 => "HTTP/1.1 303 See Other",
            304 => "HTTP/1.1 304 Not Modified",
            305 => "HTTP/1.1 305 Use Proxy",
            307 => "HTTP/1.1 307 Temporary Redirect",
            400 => "HTTP/1.1 400 Bad Request",
            401 => "HTTP/1.1 401 Unauthorized",
            402 => "HTTP/1.1 402 Payment Required",
            403 => "HTTP/1.1 403 Forbidden",
            404 => "HTTP/1.1 404 Not Found",
            405 => "HTTP/1.1 405 Method Not Allowed",
            406 => "HTTP/1.1 406 Not Acceptable",
            407 => "HTTP/1.1 407 Proxy Authentication Required",
            408 => "HTTP/1.1 408 Request Time-out",
            409 => "HTTP/1.1 409 Conflict",
            410 => "HTTP/1.1 410 Gone",
            411 => "HTTP/1.1 411 Length Required",
            412 => "HTTP/1.1 412 Precondition Failed",
            413 => "HTTP/1.1 413 Request Entity Too Large",
            414 => "HTTP/1.1 414 Request-URI Too Large",
            415 => "HTTP/1.1 415 Unsupported Media Type",
            416 => "HTTP/1.1 416 Requested range not satisfiable",
            417 => "HTTP/1.1 417 Expectation Failed",
            500 => "HTTP/1.1 500 Internal Server Error",
            501 => "HTTP/1.1 501 Not Implemented",
            502 => "HTTP/1.1 502 Bad Gateway",
            503 => "HTTP/1.1 503 Service Unavailable",
            504 => "HTTP/1.1 504 Gateway Time-out"
        );
        header($http[$num]);
        header("Location: $url");
    }

    // check if the given string contains any of the strings in the input array
    function strposa($haystack, $needles=array(), $offset = 0)
    {
        $chr = array();
        foreach($needles as $needle) {
            $res = strpos(strtolower($haystack), strtolower($needle), $offset);
            if ($res !== false) $chr[$needle] = $res;
        }
        if(empty($chr)) return false;
        return min($chr);
    }

    //search keys in array matching pattern
    function preg_grep_keys($pattern, $input, $flags = 0){
        return array_intersect_key($input, array_flip(preg_grep($pattern, array_keys($input),$flags)));
    }


}