<?php

    error_reporting(0); // this it to suppress warnings

    unset($CFG);

    global $CFG;

    $CFG = new stdClass();

    $CFG->browser_debug_log = false; // debug logs are written to browser console
    $CFG->server_debug_log = false; // debug logs are to error log on the server

    //$CFG->search_service_url = 'http://localhost/asc/server/search_service.php';
    //$CFG->keyword_service_url = 'http://localhost/asc/server/keyword_service.php';
    //$CFG->geoip_service_url = 'http://localhost/asc/server/geoip_service.php';

    //Production Settings
    $CFG->search_service_url = 'http://asb-server.rokkada.com/v2/search_service.php';
    $CFG->keyword_service_url = 'http://asb-server.rokkada.com/v2/keyword_service.php';
    $CFG->geoip_service_url = 'http://asb-server.rokkada.com/v2/geoip_service.php';

    $CFG->header_keys = array(
        //'OPENSSL_CONF',
        //'PATH',
        'HTTP_HOST',
        'HTTP_CONNECTION',
        'HTTP_CACHE_CONTROL',
        'HTTP_UPGRADE_INSECURE_REQUESTS',
        'HTTP_USER_AGENT',
        'HTTP_ACCEPT',
        'HTTP_ACCEPT_ENCODING',
        'HTTP_ACCEPT_LANGUAGE',
        'HTTP_COOKIE',
        //'SystemRoot',
        //'COMSPEC',
        //'PATHEXT',
        //'WINDIR',
        //'SERVER_SIGNATURE',
        //'SERVER_SOFTWARE',
        //'SERVER_NAME',
        //'SERVER_ADDR',
        //'SERVER_PORT',
        'REMOTE_ADDR',
        //'DOCUMENT_ROOT',
        //'REQUEST_SCHEME',
        //'CONTEXT_PREFIX',
        //'CONTEXT_DOCUMENT_ROOT',
        //'SERVER_ADMIN',
        //'SCRIPT_FILENAME',
        'REMOTE_PORT',
        //'GATEWAY_INTERFACE',
        //'SERVER_PROTOCOL',
        'REQUEST_METHOD',
        'QUERY_STRING',
        'REQUEST_URI',
        //'SCRIPT_NAME',
        //'PHP_SELF',
        'REQUEST_TIME_FLOAT',
        'REQUEST_TIME',
    );


    if (!function_exists('debug_to_console')) {
        function debug_to_console($data) {
            global $CFG;

            $output = '';
            if (is_array($data)) {

                if ($CFG->browser_debug_log)
                    $output = "<script>console.log( 'Debug: " . http_build_query($data, '', ', ') . "' );</script>";

                if ($CFG->server_debug_log)
                    error_log(print_r($data, TRUE), 0);

            } else {
                if ($CFG->browser_debug_log)
                    $output = "<script>console.log( 'Debug: " . $data . "' );</script>";

                if ($CFG->server_debug_log)
                    error_log($data, 0);
            }
            echo $output;
        }
    }



    $CFG->site_name = "Printable Kids Worksheets";
    //$CFG->site_url = 'http://pkw.com'; // dev
    $CFG->site_url = 'https://printablekidsworksheets.com'; // prod
    $CFG->site_type = 'ws';
    $CFG->site_meta_title = 'Welcome';
    $CFG->site_meta_title_suffix = 'Kids Worksheets';
    $CFG->site_meta_desc = 'Free Worksheets in Kindergarten, Phonics, Reading, Writing, Math, Science, Grammar. Categories include Addition, Algebra, Decimal, Division, Fraction, Graph, Geometry, Greater Than-Less Than, Hundreds, In-Out, Integers, Measurement, Multiplication, Place Value, Subtraction, Time, Weather, Insects, Human Body, Plant, Animal, Matter, Space, Phonics, Vowels, Consonants, Alphabets, Numbers, Shapes, Puctuation, Pronouns, Adverbs, Adjectives, Verbs, Nouns, 1st Grade Reading, 2nd Grade Reading, 3rd Grade Reading, Cursive Writing, Hindi, Sanskrit, Urdu, CBSE, ICSE, Common Core.';
    $CFG->site_meta_keywords = 'Kids, Worksheets, School, Printable, Grammar, Reading, Writing, Phonics, Quiz, Math, Science, Kindergarten, Composition, 1st Grade, 2nd Grade, 3rd Grade, 4th Grade, 5th Grade, Social Studies';

    $CFG->site_content_json = 'data/pkw-content.json';
    $CFG->old_search_param = 'ws'; // for existing site search url param

    $CFG->search_box_placeholder = 'Enter worksheet name...'; // used in search form input
    $CFG->no_results_message = 'Oops...no worksheet found.  Check & try again with correct worksheet name.'; // used in sresults.php

    $CFG->site_search_uri = $CFG->site_url.'/topic/';
    $CFG->invalid_search_url = $CFG->site_url . '/category/invalid-worksheets'; // this to match key in data json
    $CFG->unauth_search_url = $CFG->site_url . '/category/invalid-worksheets'; // this to match key in data json

    // this is for managing local search history
    $CFG->hconfig = array(
        "id" => "pkw",
        //"path" => "C:/bing-cache/client/pkw.sync", // dev
        "path" => "/home/indiael1/public_html/sites/v1/hcache/pkw.sync", //production
        "size" => "15"
    );

    // common core
    $CFG->cc_ela_content_json = 'data/cc-ela-content.json';
    $CFG->cc_math_content_json = 'data/cc-math-content.json';
    
    
    // whether to show social locker or not
    $CFG->show_locker = false; // switched off on 15th feb 2018 to see the impact on bounce
    
    $CFG->eu_countries = array('BE', 'BG', 'CZ', 'DK', 'DE', 'EE', 'IE', 'EL', 'ES', 'FR', 'HR', 'IT', 'CY', 'LV', 'LT', 'LU', 'HU', 'MT', 'NL', 'AT', 'PL', 'PT', 'RO', 'SI', 'SK', 'FI', 'SE', 'UK');

    //sb ad display target countries
    // India, Philiphines, Pakistan, Emirates, Bangladesh, Srilanka, South Africa, Saudi Arabia
    $CFG->sb_ad_target_countries = array ('IN', 'PH', 'PK', 'AE', 'BD', 'LK', 'ZA', 'SA');

    // ads script
    $CFG->g_ad_top_banner = '<script async src="//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
                                        <!-- PKW_RES_TOP -->
                                        <ins class="adsbygoogle"
                                             style="display:block"
                                             data-ad-client="ca-pub-6997161217503277"
                                             data-ad-slot="6144606427"
                                             data-ad-format="auto"></ins>
                                        <script>
                                            (adsbygoogle = window.adsbygoogle || []).push({});
                                        </script>';
                                        
    $CFG->g_ad_search_right = '<script async src="//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
                                        <!-- PKW_RES_TOP -->
                                        <ins class="adsbygoogle"
                                             style="display:block"
                                             data-ad-client="ca-pub-6997161217503277"
                                             data-ad-slot="6144606427"
                                             data-ad-format="auto"></ins>
                                        <script>
                                            (adsbygoogle = window.adsbygoogle || []).push({});
                                        </script>';

    $CFG->g_ad_body_main = '<script async src="//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
                                        <!-- PKW_RES_MAIN -->
                                        <ins class="adsbygoogle"
                                             style="display:block"
                                             data-ad-client="ca-pub-6997161217503277"
                                             data-ad-slot="5307001622"
                                             data-ad-format="auto"></ins>
                                        <script>
                                        (adsbygoogle = window.adsbygoogle || []).push({});
                                        </script>';

    $CFG->g_ad_body_right = '<script async src="//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
                                        <!-- PKW_RES_RIGHT2 -->
                                        <ins class="adsbygoogle"
                                             style="display:block"
                                             data-ad-client="ca-pub-6997161217503277"
                                             data-ad-slot="1461820028"
                                             data-ad-format="auto"></ins>
                                        <script>
                                        (adsbygoogle = window.adsbygoogle || []).push({});
                                        </script>';

    $CFG->g_ad_body_right2 = '<script async src="//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
                                        <!-- PKW_RES_RIGHT3 -->
                                        <ins class="adsbygoogle"
                                             style="display:block"
                                             data-ad-client="ca-pub-6997161217503277"
                                             data-ad-slot="9425738829"
                                             data-ad-format="auto"></ins>
                                        <script>
                                        (adsbygoogle = window.adsbygoogle || []).push({});
                                        </script>';
    	
    $CFG->g_page_ad_script = '<script async src="//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
                                            <script>
                                            (adsbygoogle = window.adsbygoogle || []).push({
                                                google_ad_client: "ca-pub-6997161217503277",
                                                enable_page_level_ads: true
                                              });
                                            </script>'; // this is inserted in the header to enable page level ads for mobile
                                            
    // SKOOLBOX ADS
    // 300x250 - is your school ready for skoolbox?
    $CFG->sb_ad_body_right = '<script type="text/javascript">
                                var bannersnack_embed = {"hash":"bcpad0alt","width":300,"height":250,"t":1471583891,"userId":24964696,"type":"html5"};
                              </script>
                            <script type="text/javascript" src="//cdn.bannersnack.com/iframe/embed.js"></script>';

     // 300x600
     /*
     '<script type="text/javascript">
				var bannersnack_embed = {"hash":"bxn8rasf1","width":300,"height":600,"t":1471587383,"userId":24964696,"type":"html5"};
				</script>
				<script type="text/javascript" src="//cdn.bannersnack.com/iframe/embed.js"></script>';
    */

    // end of ad script

    // g analytics script
    $CFG->g_analytics_script = '<script type="text/javascript">
                                          var _gaq = _gaq || [];
                                          _gaq.push([\'_setAccount\', \'UA-32965194-1\']);
                                          _gaq.push([\'_trackPageview\']);

                                          (function() {
                                              var ga = document.createElement(\'script\'); ga.type = \'text/javascript\'; ga.async = true;
                                              ga.src = (\'https:\' == document.location.protocol ? \'https://ssl\' : \'http://www\') + \'.google-analytics.com/ga.js\';
                                              var s = document.getElementsByTagName(\'script\')[0]; s.parentNode.insertBefore(ga, s);
                                          })();

                                        </script>';
    // end of g analytics script

?>