<?php
	include 'client/minifier.php';
    ob_start();
?>

<?php
    require_once 'client/bingc.lib.php';
    include 'config.php';

    global $CFG;

    $request_type = ""; // used in decide on the include page
    $page_title = $CFG->site_meta_title;
    $page_desc = $CFG->site_meta_desc;
    $page_keywords = $CFG->site_meta_keywords;
    $page_desc = $CFG->site_meta_desc;

    $content_title = '';
    $content_html = '';
    $response = '';

    $history = '';

    // add to history
    $bclient = new bingc\client();
    
    //*** Jan 12th 2019
	// this code is for getting geo info (country) for a given client ip (used for displaying sb ads)
	// IMPORTANT - this code does not return data for local IP (local testing)
	$geo_info = $bclient->get_geoip_info($_SERVER['REMOTE_ADDR'], $CFG->site_type, $_SERVER['HTTP_HOST']);

	// for testing
	//$geo_info = $bclient->get_geoip_info('43.224.158.176', 'cp', $_SERVER['HTTP_HOST']);

	//echo $geo_info['data']['log'];
	//debug_to_console($geo_info['data']);
	// Jan 12th 2019 ***//

    if (isset($_GET[$CFG->old_search_param]) && trim($_GET[$CFG->old_search_param] != '')) { // make sure there is no html or echo before 301 redirect

        debug_to_console("client - keyword is " . $_GET[$CFG->old_search_param]);
        // check if keyword is valid and also get slug to use in the url
        $response = $bclient->check_keyword($_GET[$CFG->old_search_param], $CFG->site_type, $_SERVER['HTTP_HOST']);

        //echo 'log ' . $response['data']['log'];
        debug_to_console($response['data']);

        // check if it is authorised request (query/keyword will be set)
        if(isset($response['data']['query'])) {

            if (!$response['data']['query']['keyword']['is_valid']) {

                debug_to_console('client - keyword is not valid');
                header("Location: $CFG->invalid_search_url");

            } else {

                $url = $CFG->site_search_uri . $response['data']['query']['keyword']['slug'];
                debug_to_console('client - redirect to ' . $url);
                header("HTTP/1.1 301 Moved Permanently");
                header("Location: $url");
            }
        }
        else {
                debug_to_console('client - unauthorised request');
                header("Location: $CFG->unauth_search_url");
        }
    }
    else if (isset($_GET['s'])) {  // this param is set in .htaccess file as part of url rewrite

        $request_type = 'search'; // include
        //echo '[s-condition]keyword: ' . $_GET['s']."<br>";

        $response = $bclient->get($_GET['s'], $CFG->site_type, $_SERVER['HTTP_HOST'], $geo_info);

        //echo $response['data']['log'];
		debug_to_console('client - logging entire response');
		debug_to_console($response);

        if (isset($response['data']['results'])) {
            debug_to_console($response['data']['results']);
        }

        // check if it is authorised request (query/keyword will be set)
        if(isset($response['data']['query'])) {

            if (!$response['data']['query']['keyword']['is_valid']) {
                debug_to_console('client - keyword is not valid');
                header("Location: $CFG->invalid_search_url");

            } else {
                $page_title = $response['data']['query']['keyword']['title_text'];

                $content_title = $response['data']['query']['keyword']['title_text'];

				// new page desc code improve seo
				$clean_piped_titles = $bclient->clean_result_titles($response, 'cp');
				$page_desc_str = 'Showing ' . count($response['data']['results']).' coloring pages related to ' . $content_title . '. ';
				$page_desc_str .= 'Some of the coloring pages shown here are ' .  str_replace('|', ', ', $clean_piped_titles) . '.';
				$page_desc = substr($page_desc_str, 0, strpos($page_desc_str, ' ', 160)) . '...';

				// this below array containing clean titles is used to populate alt and title tags of image results
				$clean_titles_a = explode('|', $clean_piped_titles);

				$page_keywords = $response['data']['query']['keyword']['clean_text'];
                $bclient->add_to_history($response['data']['query']['keyword']['title_text'].'|'.$response['data']['query']['keyword']['slug']);
            }
        }
        else {
            debug_to_console('client - unauthorised request');
            header("Location: $CFG->unauth_search_url");
        }

    }
    else if (isset($_GET['p'])) { // this param is set in .htaccess file as part of url rewrite
        $request_type = 'page'; // include content.php
        //echo 'page: ' . $_GET['p'];

        $content = file_get_contents($CFG->site_content_json);
        $cname = $_GET['p'];
        $json_a = json_decode($content, true);
        //var_dump(json_decode($content, true));
        //echo "<script> console.log('".$json_a."');</script>";
        //echo "request name: " . $cname;
        if (isset($json_a['categories'][$cname])) {
            //echo "content name: " . $json_a['categories'][$cname]['title'];
            $page_title = $json_a['categories'][$cname]['title'];
            $page_desc = $json_a['categories'][$cname]['title'];
            $page_keywords = $json_a['categories'][$cname]['title'];

            $content_title = $json_a['categories'][$cname]['title'];
            $content_html = $json_a['categories'][$cname]['html'];
        }
        else {
            echo "<script> console.log('client - content data not found');</script>";
            debug_to_console('client - unauthorised request');
            header("Location: $CFG->unauth_search_url");

        }
    }
    else {
        $request_type = '';
    }

?>

<!DOCTYPE html>
<html lang="en">
	<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->

		<title><?php echo $page_title.' - '. $CFG->site_meta_title_suffix; ?></title>
		<base href="<?php echo $CFG->site_url; ?>" />
		<meta name="keywords" content="<?php echo $page_keywords; ?>" />
		<meta name="author" content="PCP" />
		<meta name="description" content="<?php echo $page_desc; ?>" />
		<link href="favicon.ico" rel="shortcut icon" type="image/vnd.microsoft.icon" />

		<!-- Bootstrap 4 CSS. -->
		<link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">

		<link rel="stylesheet" type="text/css" href="/css/jquery.floating-social-share.min.css" />
		<!-- Custom CSS: You can use this stylesheet to override any Bootstrap styles and/or apply your own styles -->
		<link href="/css/custom.css" rel="stylesheet">

		<!-- For icons -->
		<link href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet" integrity="sha384-wvfXpqpZZVQGK6TAh5PVlGOfQNHSoD2xbE+QkPxCAFlNEevoEH3Sl0sibVcOQVnN" crossorigin="anonymous">

		<?php /* this is not need as IE 8 usage is very low - kunmans May 4th 2018
		<!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
		<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->

		<!--[if lt IE 9]>
		<script src="//oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
		<script src="//oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
		<![endif]-->
		*/ ?>

		<?php echo $CFG->g_analytics_script; ?>
		<?php echo $CFG->g_page_ad_script; ?>

		<?php /*
 			<link href="/css/pandalocker.2.3.1.min.css" rel="stylesheet">
			<script type="text/javascript" src="/js/pandalocker.2.3.1.min.js"></script>
		*/ ?>

		<?php /*
			// added mar 8th 2017. hide social locker for US & other high cpc countries
			if (!(in_array($geo_info['data']['country_iso'], $CFG->slocker_hide_countries))) {
		//?>
			<script>
				jQuery(document).ready(function ($) {
					$('.to-lock').sociallocker({
						theme: 'dandyish',
						overlap:{
							mode: 'blurring',
							intensity: '5'
						},
						buttons:{
							order: ["facebook-like","google-plus"],
							counters: true,
							lazy: false
						},
						facebook: { like: { url: "https://printablecoloringpages.in" } },
						google: { plus: { url: "https://printablecoloringpages.in" } },
						url: 'https://printablecoloringpages.in',
						text: {
							header: 'Like us to view coloring pages',
							message: 'Like us on facebook or google plus to access coloring pages..thank you.<br/>*In case you don\'t see coloring pages after like, please refresh the page.<br/>'
						}
					});
				});
			</script>
		//<?php
			}
 			*/
		?>
	</head>
	<body>
	<div class="container py-2">
		<?php include 'includes/navbar.php' ?>
		<!-- Search Row -->
		<div class="row pt-1">
			<div class="col-sm-8 py-2"><!-- Search Column -->
				<!-- Form -->
				<div class="card border-light">
					<div class="card-header bg-pink text-light">
						Search
					</div>
					<div class="card-body mx-auto py-3">
						<form class="form-inline mb-0"  method="post" action="/client/search">
							<div class="form-group mx-sm-3 mb-1 mr-2">
								<input type="text" class="form-control form-control-lg" id="s" name="s" placeholder="<?php echo $CFG->search_box_placeholder; ?>">
							</div>
							<button type="submit" class="btn btn-lg btn-outline-info mb-1"><span class="fa fa-search"></span> Search</button>
						</form>
					</div>
					<div class="card-footer bg-white p-1">
						<h5>Recent Searches</h5>
						<?php
						$hlinks = $bclient->get_history_links();
						$hlinks = str_replace($CFG->site_url, '', $hlinks);
						$hlinks = str_replace('<p>', '<div class="d-flex flex-wrap">', $hlinks);
						$hlinks = str_replace('<a ', '<a class="btn-sm border rounded py-0 px-1 mb-1 mr-1 text-info" ', $hlinks);
						$hlinks = str_replace('</p>', '</div>', $hlinks);
						$hlinks = str_replace('|', '', $hlinks);
						//$hlinks = str_replace('">', '" class="border rounded px-1 mx-1 mb-4">', $hlinks);
						//$hlinks = str_replace('|', '', $hlinks);
						//debug_to_console($hlinks);
						echo $hlinks;
						?>
					</div>
				</div>
			</div><!--/Search Column -->
			<div class="col-sm-4 py-2"><!-- Adv Column -->
				<!-- Form -->
				<div class="card border-0">
					<div class="card-header bg-pink text-light mb-2">
						Sponsored Content
					</div>
					<?php echo $CFG->g_ad_search_right; ?>
					<?php //<img src="images/ad-300x250.jpg" class="rounded mx-auto d-block"> ?>
				</div>
			</div><!--/Adv Column -->
		</div><!--/search row -->
		<hr>
		<!-- includes -->
		<?php
		if($request_type === 'search') {
			include 'includes/sresults.php';
		}
		else if($request_type === 'page') {
			include 'includes/content.php';
		}
		else {
			//echo "redirecting to home";
			include 'includes/home.php';
		}
		?>
	</div><!--/container-fluid-->
	<?php include 'includes/footer.php' ?>
	<!-- Bootstrap core JavaScript
    ================================================== -->
	<!-- Placed at the end of the document so the pages load faster -->

	<!-- jQuery library -->
	<!-- <script src="https://code.jquery.com/jquery-3.2.1.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>-->
	<script src="//code.jquery.com/jquery-3.1.1.min.js"></script>

	<?php /* this is not needed as as there is no old jquery code - kunmans May 4th 2018
	<script src="//code.jquery.com/jquery-migrate-3.0.1.js"></script>
	*/ ?>

	<!-- Popper -->
	<script src="//cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>

	<!-- Bootstrap 4 JavaScript. -->
	<script src="//maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>

	<!-- Initialize Bootstrap functionality -->
	<script>
		// Initialize tooltip component
		$(function () {
			$('[data-toggle="tooltip"]').tooltip()
		})

		// Initialize popover component
		$(function () {
			$('[data-toggle="popover"]').popover()
		})
	</script>
	<script src="/js/jquery.floating-social-share.min.js"></script>
	<script>
		<?php /*
        $("body").floatingSocialShare({
            buttons: ["facebook", "twitter", "google-plus"],
            text: "share with:"
        });
         */ ?>

		$(".container").floatingSocialShare({
			buttons: [
				"facebook", "twitter", "pinterest", "reddit", "whatsapp"
			],
			text: {'default': 'share with: ', 'facebook': 'share with facebook'},
			text_title_case: true,
			twitter_counter: false,
			popup: false,
			place: "content-left"
		});
	</script>
	<?php
		if(isset($geo_info['data']['country_iso']) && in_array($geo_info['data']['country_iso'], $CFG->eu_countries)) {
	?>
			<link rel="stylesheet" type="text/css" href="//cdnjs.cloudflare.com/ajax/libs/cookieconsent2/3.0.3/cookieconsent.min.css" />
			<script src="//cdnjs.cloudflare.com/ajax/libs/cookieconsent2/3.0.3/cookieconsent.min.js"></script>
			<script>
				window.addEventListener("load", function(){
					window.cookieconsent.initialise({
			  			"palette": {
				  			"popup": {
							"background": "#efefef",
				  			"text": "#404040"
						},
						"button": {
							"background": "#8ec760",
				  			"text": "#ffffff"
					}
			  	},
			  	"theme": "classic",
			  	"content": {
					"message": "This website uses <a href='https://cookiesandyou.com' target='_blank'>cookies</a> as explained in our <a href='/privacy-policy' target='_blank'>privacy policy</a> notice to offer you a better browsing experience. ",
				  	"link": "Learn more...",
				  	"dismiss": "Got it!",
				  	"href": "https://cookiesandyou.com"
			  	}
				})});
			</script>
	<?php
		}
	?>
	</body>
	</html>

<?php
	$content = minify_html( ob_get_clean() );
	echo $content;
?>