<?php

    /*
     * this service returns related search keyword for the passed keyword
     * Logic uses making combination of words by splitting the input worksheet name and search master list of worksheet names (~60k) to find suitable match
     * Search is done by constructing multiple SQL queries using LOCATE clause with each combination to find the related keywords
     * Match is made decrementally with all keywords matched again master list first and then combination of less number of keywords
     * TO DO security feature - verify requester, timeout, exceptions,
     *
     * build se
     */
    header('Content-Type: application/json');

    set_time_limit(5); // 60 is 1 minute
    include_once dirname(__DIR__).'/config.php';
    require_once dirname(__DIR__) . '/lib/mysqlidb/MysqliDb.php';

    global $CFG;

    // common stop words to ignore from input worksheet
    $commonWords = array('a','able','about','above','abroad','according','accordingly','across','actually','adj','after','afterwards','again','against','ago','ahead','ain\'t','all','allow','allows','almost','alone','along','alongside','already','also','although','always','am','amid','amidst','among','amongst','an','and','another','any','anybody','anyhow','anyone','anything','anyway','anyways','anywhere','apart','appear','appreciate','appropriate','are','aren\'t','around','as','a\'s','aside','ask','asking','associated','at','available','away','awfully','b','back','backward','backwards','be','became','because','become','becomes','becoming','been','before','beforehand','begin','behind','being','believe','below','beside','besides','best','better','between','beyond','both','brief','but','by','c','came','can','cannot','cant','can\'t','caption','cause','causes','certain','certainly','changes','clearly','c\'mon','co','co.','com','come','comes','concerning','consequently','consider','considering','contain','containing','contains','corresponding','could','couldn\'t','course','c\'s','currently','d','dare','daren\'t','definitely','described','despite','did','didn\'t','different','directly','do','does','doesn\'t','doing','done','don\'t','down','downwards','during','e','each','edu','eg','eight','eighty','either','else','elsewhere','end','ending','enough','entirely','especially','et','etc','even','ever','evermore','every','everybody','everyone','everything','everywhere','ex','exactly','example','except','f','fairly','far','farther','few','fewer','fifth','first','five','followed','following','follows','for','forever','former','formerly','forth','forward','found','four','from','further','furthermore','g','get','gets','getting','given','gives','go','goes','going','gone','got','gotten','greetings','h','had','hadn\'t','half','happens','hardly','has','hasn\'t','have','haven\'t','having','he','he\'d','he\'ll','hello','help','hence','her','here','hereafter','hereby','herein','here\'s','hereupon','hers','herself','he\'s','hi','him','himself','his','hither','hopefully','how','howbeit','however','hundred','i','i\'d','ie','if','ignored','i\'ll','i\'m','immediate','in','inasmuch','inc','inc.','indeed','indicate','indicated','indicates','inner','inside','insofar','instead','into','inward','is','isn\'t','it','it\'d','it\'ll','its','it\'s','itself','i\'ve','j','just','k','keep','keeps','kept','know','known','knows','l','last','lately','later','latter','latterly','least','less','lest','let','let\'s','like','liked','likely','likewise','little','look','looking','looks','low','lower','ltd','m','made','mainly','make','makes','many','may','maybe','mayn\'t','me','mean','meantime','meanwhile','merely','might','mightn\'t','mine','minus','miss','more','moreover','most','mostly','mr','mrs','much','must','mustn\'t','my','myself','n','name','namely','nd','near','nearly','necessary','need','needn\'t','needs','neither','never','neverf','neverless','nevertheless','new','next','nine','ninety','no','nobody','non','none','nonetheless','noone','no-one','nor','normally','not','nothing','notwithstanding','novel','now','nowhere','o','obviously','of','off','often','oh','ok','okay','old','on','once','one','ones','one\'s','only','onto','opposite','or','other','others','otherwise','ought','oughtn\'t','our','ours','ourselves','out','outside','over','overall','own','p','particular','particularly','past','per','perhaps','placed','please','plus','possible','presumably','probably','provided','provides','q','que','quite','qv','r','rather','rd','re','really','reasonably','recent','recently','regarding','regardless','regards','relatively','respectively','right','round','s','said','same','saw','say','saying','says','second','secondly','see','seeing','seem','seemed','seeming','seems','seen','self','selves','sensible','sent','serious','seriously','seven','several','shall','shan\'t','she','she\'d','she\'ll','she\'s','should','shouldn\'t','since','six','so','some','somebody','someday','somehow','someone','something','sometime','sometimes','somewhat','somewhere','soon','sorry','specified','specify','specifying','still','sub','such','sup','sure','t','take','taken','taking','tell','tends','th','than','thank','thanks','thanx','that','that\'ll','thats','that\'s','that\'ve','the','their','theirs','them','themselves','then','thence','there','thereafter','thereby','there\'d','therefore','therein','there\'ll','there\'re','theres','there\'s','thereupon','there\'ve','these','they','they\'d','they\'ll','they\'re','they\'ve','thing','things','think','third','thirty','this','thorough','thoroughly','those','though','three','through','throughout','thru','thus','till','to','together','too','took','toward','towards','tried','tries','truly','try','trying','t\'s','twice','two','u','un','under','underneath','undoing','unfortunately','unless','unlike','unlikely','until','unto','up','upon','upwards','us','use','used','useful','uses','using','usually','v','value','various','versus','very','via','viz','vs','w','want','wants','was','wasn\'t','way','we','we\'d','welcome','well','we\'ll','went','were','we\'re','weren\'t','we\'ve','what','whatever','what\'ll','what\'s','what\'ve','when','whence','whenever','where','whereafter','whereas','whereby','wherein','where\'s','whereupon','wherever','whether','which','whichever','while','whilst','whither','who','who\'d','whoever','whole','who\'ll','whom','whomever','who\'s','whose','why','will','willing','wish','with','within','without','wonder','won\'t','would','wouldn\'t','x','y','yes','yet','you','you\'d','you\'ll','your','you\'re','yours','yourself','yourselves','you\'ve','z','zero');

    // common worksheet words to ignore from input worksheet
    $wsCommonWords = array('free', 'printables', 'printable', 'worksheets', 'worksheet', 'sheet', 'kids', 'grade', 'class', 'practice', 'sentences', 'activities', 'books', 'parts');
    //$input = preg_replace('/\b('.implode('|',$commonWords).')\b/','',$input);
    //$input = trim(preg_replace('/\s\s+/', ' ', str_replace("\n", " ", $input));

    debug_to_console('ascga related search service - Inside Service');

    $kw_master_tbl = 'bng_ascga_keyword';
    $query_sel_limit = 20;
    $max_results = 20; // this is number of results to return
    $min_kw_len = 3; // only words with 3 char or more considered for matching

    // get the worksheet being searched
    $ws = $_GET['key'];

    // if key is empty, return empty json
    if (trim($ws) === '') {
        echo '{}';
        exit;
    }

    $ws = strtolower($ws); //convert to lower case
    $ws_slug = trim(str_replace(' ', '-', $ws));

    debug_to_console('ascga related search service - Passed Keyword->' . $ws);

    //replace - with space
    $ws = str_replace('-', ' ', $ws);

    // remove stop words
    $ws = preg_replace('/\b(' . implode('|', $commonWords) . ')\b/', '', $ws);

    // remove worksheet common words
    $ws = preg_replace('/\b(' . implode('|', $wsCommonWords) . ')\b/', '', $ws);


    debug_to_console('ascga related search service - Cleaned Keyword->' . $ws);

    // remove any words less 2 chars or less
    $ws =  preg_replace('/\b[a-z0-9]{1,2}\b/', '', $ws);

    // remove double space, etc
    $ws = trim(preg_replace('/\s\s+/', ' ', str_replace("\n", " ", $ws)));

    debug_to_console('ascga related search service - Cleaned Keyword->' . $ws);

    // explode ws by space and create combination of words for look up
    $ws_kw_aa = getCombinations(explode(' ', $ws));
    debug_to_console('ascga related search service - Keyword Combinations ->' . count($ws_kw_aa));

    debug_to_console($ws_kw_aa);

    //
    $ws_kw_a = array();
    foreach($ws_kw_aa as $v) {
        debug_to_console('ascga related search service - ' . implode(" ", $v) . "<br />");
        $p = implode(" ", $v);
        //if (strlen($p) >= $min_kw_len) {
            array_push($ws_kw_a, $p);
        //}
    }

    debug_to_console($ws_kw_a);

    // this is
    usort($ws_kw_a, function($a, $b){
        $countA = substr_count($a, " ")+1;
        $countB = substr_count($b, " ")+1;

        if($countA == $countB) {
            return strcasecmp($a, $b);
        } else {
            return $countA > $countB ? 1 : -1;
        }
    });

    $ws_kw_a = array_reverse($ws_kw_a);

    $ws_kw_p = ''; //$wname . '|';
    foreach($ws_kw_a as $p) {
        if (strlen($p) > 1) {
            $ws_kw_p .= $p . '|';
        }
    }
    $ws_kw_p = rtrim($ws_kw_p, '|');

    //$w_keys = $wname;
    debug_to_console('ascga related search service - ' . 'inuput kw->' . $ws . '  piped combinations->' . $ws_kw_p . '<br>');


    $db = new \MysqliDb (Array(
        'host' => $CFG->dbhost,
        'username' => $CFG->dbuser,
        'password' => $CFG->dbpass,
        'db' => $CFG->dbname,
        'port' => 3306,
        'prefix' => $CFG->prefix,
        'charset' => 'utf8'));


    debug_to_console('ascga related search service - ' . '<br><br>********* Results of Locate ********** <br><br>');
    $rel_kw_results = array();
    foreach ($ws_kw_a as $ws_kw) {
        $kwi_a = explode(' ', $ws_kw);
        $wh = ' WHERE ';
        foreach($kwi_a as $kwi) {
            $wh .=  ' LOCATE(\'' . $kwi . '\', keyword) > 0 ';
            $wh .= ' AND ';
        }
        $wh = str_lreplace('AND', '', $wh);
        $query = 'select * from  ' . $kw_master_tbl . ' ' . $wh . ' LIMIT ' . $query_sel_limit;

        debug_to_console('ascga related search service - Querying DB with ->' . $query . '<br>');

        $rel_kws_a = $db->rawQuery($query);
        $rel_kw_results = array_merge($rel_kw_results, $rel_kws_a);

        if(count($rel_kws_a) < 1) {
            debug_to_console('ascga related search service - ' . '<br>No match found for ' .  $ws_kw . '<br>');
        }
        else {
            debug_to_console('ascga related search service - ' . '<br><b>' . $ws_kw . '</b> -  Found ' .  count($rel_kws_a) . ' matches.<br>');
        }

        foreach($rel_kws_a as $rel_kw) {
            debug_to_console('ascga related search service - ' . $rel_kw['keyword'] . '|' . $rel_kw['slug'] . '<br>');
        }

        if (count($rel_kw_results) > ($max_results + 5)) { // using buffer of 5 more results as there may be duplicates which will removed later
            break;
        }
    }

    debug_to_console('ascga related search service - raw result count->' . count($rel_kw_results));
    //echo json_encode($rel_kw_results, JSON_PRETTY_PRINT);

    $rel_kw_results = array_unique($rel_kw_results, SORT_REGULAR);

    // remove original ws from the related ws results
    $rel_kw_results = removeElementWithValue($rel_kw_results, "slug", $ws_slug);

    //echo json_encode($rel_kw_results, JSON_PRETTY_PRINT);
    $rel_kw_results = array_values($rel_kw_results);

    debug_to_console('ascga related search service - unique result count->' . count($rel_kw_results));

    // slice array to return only max results
    $rel_kw_results = array_slice($rel_kw_results, 0, $max_results);

    debug_to_console('ascga related search service - final result count->' . count($rel_kw_results));
    debug_to_console(($rel_kw_results));
    //echo json_encode($rel_kw_results, JSON_PRETTY_PRINT);
    echo json_encode($rel_kw_results);



    // function to make combination of different keywords in a worksheet name
    function getCombinations($array) {
        //initalize array
        $results = [[]];

        //get all combinations
        foreach ($array as $k => $element) {
            foreach ($results as $combination)
                $results[] =  $combination + [$k => $element];
        }
        //return filtered array
        return array_values(array_filter($results));
    }

    function str_lreplace($search, $replace, $subject)
    {
        $pos = strrpos($subject, $search);

        if($pos !== false)
        {
            $subject = substr_replace($subject, $replace, $pos, strlen($search));
        }

        return $subject;
    }

    // this is used to remove array item from multidimentional array based on value of a particular key
    function removeElementWithValue($array, $key, $value){
        foreach($array as $subKey => $subArray){
            if($subArray[$key] == $value){
                unset($array[$subKey]);
            }
        }
        return $array;
    }


