<?php
    /**
     * Created by PhpStorm.
     * User: Man
     * Date: 16-09-2018
     * Time: 08:45 AM
     */

    set_time_limit(0);
    ini_set('memory_limit','-1');

    // Turn off all error reporting
    //error_reporting(0); // this is important otherwise file io warning is also sent in response to client

    include_once dirname(__DIR__).'/../config.php';
    include_once dirname(__DIR__).'/../lib/util.php';
    //include '../../lib/util.php';
    require_once dirname(__DIR__) . '/../lib/mysqlidb/MysqliDb.php';

    global $CFG;


    $db = new \MysqliDb (Array(
        'host' => $CFG->dbhost,
        'username' => $CFG->dbuser,
        'password' => $CFG->dbpass,
        'db' => $CFG->dbname,
        'port' => 3306,
        'prefix' => $CFG->prefix,
        'charset' => 'utf8'));


    // status email
    $subject = "UNAUTH Archival - " . date("j M Y, l");
    $status = '**PASS**';
    $body = '<html><title>' . $subject . '</title>';
    $body .= '<body><ul>';
    $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': unauth archival: initiating unauth archival</li>';

    debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': unauth archival: initiating unauth archival');

    // current month year MMYYYY (as of yesterday)
    $date = new \DateTime('now');
    $ydate = new \DateTime('now');
    $ydate->modify("-1 day");// yesterday
    $month = $ydate->format('m');
    $year = $ydate->format('Y');
    $tbl_suffix = $month . $year;

    $unauth_main_table = $CFG->prefix . 'unauth_request';
    // archival table
    $unauth_arch_tbl_name = $unauth_main_table . '_' . $tbl_suffix;
    debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': unauth archival: archival table name ' . $unauth_arch_tbl_name);
    $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': unauth archival: archival table name - <b>' . $unauth_arch_tbl_name . '</b></li>';

    // check if
    $checktable = $db->rawQuery("SHOW TABLES LIKE '$unauth_arch_tbl_name'");
    $table_exists = count($checktable) > 0 ? true: false;

    if($table_exists) {
        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': unauth archival: archival table exists');
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': unauth archival: archival table exists</li>';
        
        // count of unauth requests by bot ip (top 20)
        $result = $db->rawQuery("SELECT site s, user_ip ip, substring_index(substring_index(header_json, 'HTTP_USER_AGENT', -1), 'HTTP_ACCEPT', 1) a, count(*) c  FROM $unauth_main_table group by s, ip order by c desc limit 20");

        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': unauth archival: count of BOT unauth requests by IP [top 20] - ');
        debug_to_console($result);
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': unauth archival: count of BOT unauth requests by IP [top 20]<br>';

        $body .= '<table border="1">';
        foreach($result as $child) {
            $body .= '<tr><td>' . $child['s'] . '</td><td>' . $child['ip'] . '</td><td>' . $child['a'] . '</td><td>' . $child['c'] . '</td></tr>';
        }
        $body .= '</table>';
        $body .= '</li>';

        // total records to be archived
        $db->where('creation_date', $date->format('Y-m-d'), '<');
        $count = $db->getValue("unauth_request", "count(*)");

        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': unauth archival: total records to be archived - ' . $count);
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': unauth archival: total records to be archived - <b>' . $count . '</b></li>';

        /* getting 500 error - using direct insert into -- 6th feb 2018
        // archive all records from main to archival till yesterday
        $db->where('creation_date', $date->format('Y-m-d'), '<');
        $records = $db->get('unauth_request');
        $db->insertMulti('unauth_request_' . $tbl_suffix, $records);
        */
        
        //$db->rawQuery("INSERT INTO '$unauth_arch_tbl_name' SELECT * FROM '$unauth_main_table' where CREATION_DATE < '2018-09-22'");
        $db->rawQuery("INSERT INTO " . $unauth_arch_tbl_name . " SELECT * FROM ". $unauth_main_table . " where CREATION_DATE < '" . $date->format('Y-m-d') . "'");
        
        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': unauth archival: insertion to archive table completed');
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': unauth archival: insertion to archive table completed</li>';

        //delete all archived records from main table
        $db->where('creation_date', $date->format('Y-m-d'), '<');
        $db->delete('unauth_request');
        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': unauth archival: deletion from main table completed.');
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': unauth archival: deletion from main table completed</li>';
        
    }
    else {
        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': unauth archival: ERROR - archival table does not exist');
        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': unauth archival: ERROR - archival aborted');
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': unauth archival: ERROR - archival table does not exist</li>';
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': unauth archival: ERROR - archival aborted</li>';
        $status = '**FAIL**';
    }
    debug_to_console(date("d-m-Y H:i:s.u") . ': unauth archival: email being sent.');
    $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': unauth archival: email being sent.</li>';
    $body .= "</ul></body></html>";

    sendsmtpmail("no-reply@webilify.com", "sysadmin@rokkada.com,kunmans@gmail.com,kunmans@live.com,sysadmin@webilify.com", $status . ' ' . $subject, $body);
    debug_to_console(date("d-m-Y H:i:s.u") . ': unauth archival: email sent.');
    echo $body;

