<?php
    /**
     * Created by PhpStorm.
     * User: Man
     * Date: 16-09-2018
     * Time: 08:45 AM
     */

    set_time_limit(0);
    ini_set('memory_limit','-1');

    // Turn off all error reporting
    error_reporting(0); // this is important otherwise file io warning is also sent in response to client

    include_once dirname(__DIR__).'/../config.php';
    include_once dirname(__DIR__).'/../lib/util.php';
    //include '../../lib/util.php';
    require_once dirname(__DIR__) . '/../lib/mysqlidb/MysqliDb.php';

    global $CFG;


    $db = new \MysqliDb (Array(
        'host' => $CFG->dbhost,
        'username' => $CFG->dbuser,
        'password' => $CFG->dbpass,
        'db' => $CFG->dbname,
        'port' => 3306,
        'prefix' => $CFG->prefix,
        'charset' => 'utf8'));


    // status email
    $subject = "CP Archival - " . date("j M Y, l");
    $status = '**PASS**';
    $body = '<html><title>' . $subject . '</title>';
    $body .= '<body><ul>';
    $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: initiating cp archival</li>';

    debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: initiating cp archival');

    // current month year MMYYYY (as of yesterday)
    $date = new \DateTime('now');
    $ydate = new \DateTime('now');
    $ydate->modify("-1 day");// yesterday
    $month = $ydate->format('m');
    $year = $ydate->format('Y');
    $tbl_suffix = $month . $year;

    $cp_main_table = $CFG->prefix . 'cp_request';
    // archival table
    $cp_arch_tbl_name = $cp_main_table . '_' . $tbl_suffix;
    debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: archival table name ' . $cp_arch_tbl_name);
    $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: archival table name - <b>' . $cp_arch_tbl_name . '</b></li>';

    // check if
    $checktable = $db->rawQuery("SHOW TABLES LIKE '$cp_arch_tbl_name'");
    $table_exists = count($checktable) > 0 ? true: false;

    if($table_exists) {
        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: archival table exists');
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: archival table exists</li>';
        
        // total bing api calls
        $db->where('served_from', '%api%', 'like');
        $count = $db->getValue('cp_request', 'count(*)');
        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: total bing api calls - ' . $count);
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: total bing api calls - <b>' . $count . '</b></li>';
        
        // total bing api calls by users
        $db->where('served_from', '%api%', 'like');
        $db->where('agent', 'user');
        $count = $db->getValue('cp_request', 'count(*)');
        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: total bing api calls by users - ' . $count);
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: total bing api calls by users - <b>' . $count . '</b></li>';

        // total bing api calls by bots
        $db->where('served_from', '%api%', 'like');
        $db->where('agent', 'bot');
        $count = $db->getValue('cp_request', 'count(*)');
        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: total bing api calls by bots - ' . $count);
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: total bing api calls by bots - <b>' . $count . '</b></li>';

        // api calls by site
        $result = $db->rawQuery("SELECT site, agent, count(*) c FROM $cp_main_table where served_from like '%api%' group by site order by c desc");

        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: bing api calls by site - ');
        debug_to_console($result);
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: bing api calls by site<br>';
        $body .= '<table border="1">';
        foreach($result as $child) {
            $body .= '<tr><td>' . $child['site'] . '</td><td>' . $child['agent'] . '</td><td>' . $child['c'] . '</td></tr>';
        }
        $body .= '</table>';
        $body .= '</li>';
        
        // api calls by country (top 10)
        $result = $db->rawQuery("SELECT user_geo_2 country, count(*) c FROM $cp_main_table where served_from like '%api%' group by country order by c desc limit 10");

        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: bing api calls by country [top 10] - ');
        debug_to_console($result);
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: bing api calls by country [top 10]<br>';
        
        $body .= '<table border="1">';
        foreach($result as $child) {
            $body .= '<tr><td>' . $child['country'] . '</td><td>' . $child['c'] . '</td></tr>';
        }
        $body .= '</table>';
        $body .= '</li>';
        
        // api calls by ip (top 10)
        $result = $db->rawQuery("SELECT count(*) c, user_ip ip FROM $cp_main_table where served_from like '%api%' group by user_ip order by c desc limit 10");

        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: bing api calls by IP [top 10] - ');
        debug_to_console($result);
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: bing api calls by IP [top 10]<br>';

        $body .= '<table border="1">';
        foreach($result as $child) {
            $body .= '<tr><td>' . $child['ip'] . '</td><td>' . $child['c'] . '</td></tr>';
        }
        $body .= '</table>';
        $body .= '</li>';

        // count of cp requests by bot 
        $result = $db->rawQuery("SELECT count(*) c, substring_index(substring_index(header_json, 'HTTP_USER_AGENT', -1), 'HTTP_ACCEPT', 1) a FROM $cp_main_table group by a order by c desc limit 20");

        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: count of BOT ws requests by bot across sites - ');
        debug_to_console($result);
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: count of BOT ws requests by bot across sites<br>';

        $body .= '<table border="1">';
        foreach($result as $child) {
            $body .= '<tr><td>' . $child['c'] . '</td><td>' . $child['a'] . '</td></tr>';
        }
        $body .= '</table>';
        $body .= '</li>';
        
        // count of cp requests by bot 
        $result = $db->rawQuery("SELECT site s, count(*) c, substring_index(substring_index(header_json, 'HTTP_USER_AGENT', -1), 'HTTP_ACCEPT', 1) a FROM $cp_main_table group by s, a order by c desc limit 20");

        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: count of BOT ws requests by site - ');
        debug_to_console($result);
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: count of BOT ws requests by site<br>';

        $body .= '<table border="1">';
        foreach($result as $child) {
            $body .= '<tr><td>' . $child['s'] . '</td><td>' . $child['c'] . '</td><td>' . $child['a'] . '</td></tr>';
        }
        $body .= '</table>';
        $body .= '</li>';
        
        // total records to be archived
        $db->where('creation_date', $date->format('Y-m-d'), '<');
        $count = $db->getValue("cp_request", "count(*)");

        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: total records to be archived - ' . $count);
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: total records to be archived - <b>' . $count . '</b></li>';
        
        // archive all records from main to archival till yesterday
        $db->where('creation_date', $date->format('Y-m-d'), '<');
        $records = $db->get('cp_request');
        $db->insertMulti('cp_request_' . $tbl_suffix, $records);

        //$db->rawQuery("INSERT INTO '$cp_arch_tbl_name' SELECT * FROM '$cp_main_table' where CREATION_DATE < '2018-09-22'");
        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ':cp archival: insertion to archive table completed');
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: insertion to archive table completed</li>';

        //delete all archived records from main table
        $db->where('creation_date', $date->format('Y-m-d'), '<');
        $db->delete('cp_request');
        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: deletion from main table completed.');
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: deletion from main table completed</li>';
    }
    else {
        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: ERROR - archival table does not exist');
        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: ERROR - archival aborted');
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: ERROR - archival table does not exist</li>';
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: ERROR - archival aborted</li>';
        $status = '**FAIL**';
    }
    debug_to_console(date("d-m-Y H:i:s.u") . ': cp archival: email being sent.');
    $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': cp archival: email being sent.</li>';
    $body .= "</ul></body></html>";

    sendsmtpmail("no-reply@webilify.com", "sysadmin@rokkada.com,kunmans@gmail.com,kunmans@live.com,sysadmin@webilify.com", $status . ' ' . $subject, $body);
    debug_to_console(date("d-m-Y H:i:s.u") . ': cp archival: email sent.');
    echo $body;

