<?php

    include_once dirname(__DIR__).'/config.php';
    
    ini_set("include_path", '/home/indiael1/php:' . ini_get("include_path") );
    require_once "Mail.php";

    // Load the Google API PHP Client Library.
    require_once __DIR__ . '/../vendor/autoload.php';

    // Creates and returns the Analytics Reporting service object.
    function initializeAnalytics()
    {
        debug_to_console('ascga service - initializing Google Analytics');
        // Use the developers console and download your service account
        // credentials in JSON format. Place them in this directory or
        // change the key file location if necessary.
        $KEY_FILE_LOCATION = __DIR__ . '/../service-account-credentials.json';

        // Creates and returns the Analytics Reporting service object.
        // Create and configure a new client object.
        $client = new Google_Client();
        $client->setApplicationName("ASC GA");
        $client->setAuthConfig($KEY_FILE_LOCATION);
        $client->setScopes(['https://www.googleapis.com/auth/analytics.readonly']);
        $analytics = new Google_Service_Analytics($client);
        return $analytics;
    }

    function getPageViews($view_id, $start_date, $end_date, $options) {

        debug_to_console('ascga service - inside getPageViews method');
        debug_to_console('ascga service - view id->' . $view_id . ', start date->' . $start_date . ', end date->' . $end_date);
        debug_to_console('ascga service - options array->');
        debug_to_console($options);
        // Calls the Core Reporting API and queries for the number of sessions
        // for the last seven days.
        $analytics  = initializeAnalytics();
        return $analytics->data_ga->get(
            'ga:' . $view_id,
            $start_date,
            $end_date,
            'ga:pageviews',
            $options
        );
    }


    // function to find if haystack contains any needle in needle array
    // returns true if found else false
    function strposa($haystack, $needles=array(), $offset = 0)
    {
        $found = false;
        foreach($needles as $needle) {
            $res = strpos($haystack, $needle, $offset);
            //debug_to_console('haystack->' . $haystack . ', needle->' . $needle);
            if ($res !== false) {
                //debug_to_console('strposa -> true');
                $found = true;
                break;
            }
        }
        return $found;
    }

    // function to find if haystack contains any needle in needle array
    // returns true if found else false
    function strposai($haystack, $needles=array(), $offset = 0)
    {
        $found = false;
        foreach($needles as $needle) {
            $res = strpos(strtolower($haystack), strtolower($needle), $offset);
            //debug_to_console('haystack->' . $haystack . ', needle->' . $needle);
            if ($res !== false) {
                //debug_to_console('strposa -> true');
                $found = true;
                break;
            }
        }
        return $found;
    }

    // sep 23rd 2018 - added to build monitoring and data migration services
    function sendsmtpmail($from, $to, $subject, $message)
    {
        $headers = array(
            'MIME-Version' => '1.0',
            'Content-type' => 'text/html; charset=iso-8859-1',
            'From' => $from,
            'To' => $to,
            'Subject' => $subject
        );

        $smtp = Mail::factory('smtp', array(
            'host' => 'ssl://mail.webilify.com',
            'port' => '465',
            'auth' => true,
            'username' => 'no-reply@webilify.com', //your gmail account
            'password' => 'uNrMcGNggd91' // your password
        ));

        // Send the mail
        $mail = $smtp->send($to, $headers, $message);
    }