<?php
    /**
     * Created by PhpStorm.
     * User: Man
     * Date: 16-09-2018
     * Time: 08:45 AM
     */

    set_time_limit(0);
    ini_set('memory_limit','-1');

    // Turn off all error reporting
    error_reporting(0); // this is important otherwise file io warning is also sent in response to client

    include_once dirname(__DIR__).'/config.php';
    include_once dirname(__DIR__).'/lib/util.php';
    //include '../../lib/util.php';
    require_once dirname(__DIR__) . '/lib/mysqlidb/MysqliDb.php';

    global $CFG;

    //$service_url = 'http' . (($_SERVER['HTTPS'] == 'on') ? 's' : '') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
    $service_url = $_SERVER['REQUEST_URI'];

    $site = $_GET['site']; // e.g., pw, tw, pkw, lw, scc,
    $type = $_GET['type']; //  ws or cp
    $table = $_GET['table'];
    $served = $_GET['served'];
    $publish = isset($_GET['publish']) ? $_GET['publish'] : 'false';

    $site_details = $CFG->sites[$site];
    $site_url = $site_details['site_url'];

    $start_date = isset($_GET['start_date']) ? $_GET['start_date'] . ' 00:00:00' : ''; // YYYY-MM-DD, today, yesterday, NdaysAgo
    $end_date = isset($_GET['end_date']) ? $_GET['end_date'] . ' 23:59:59' : ''; // YYYY-MM-DD, today, yesterday, NdaysAgo

    if($served == 'api-all') {
        $served_a = Array('api', 'api-refresh');
        $served_s = "'api', 'api-refresh'";
    }
    elseif ($served == 'api-refresh') {
        $served_a = Array('api-refresh');
        $served_s = "'api-refresh'";
    }
    else {
        $served_a = Array('api');
        $served_s = "'api'";
    }

    $db = new \MysqliDb (Array(
        'host' => $CFG->dbhost,
        'username' => $CFG->dbuser,
        'password' => $CFG->dbpass,
        'db' => $CFG->dbname,
        'port' => 3306,
        'prefix' => $CFG->prefix,
        'charset' => 'utf8'));


    // current month year MMYYYY (as of yesterday)
    $date = new \DateTime('now');
    $date_ymd = $date->format('Y-m-d');

    $ydate = new \DateTime('now');
    $ydate->modify("-1 day"); //yesterday
    $month = $ydate->format('m');
    $year = $ydate->format('Y');
    $tbl_suffix = $month . $year;

    $p_table = $CFG->prefix . $table;

    // status email
    $submit_for_dt = '[< ' . $date_ymd . ']';
    if ($start_date != '' && $end_date != '') {
        $submit_for_dt = '[' . $start_date . ' - ' . $end_date . ']';
    }

    $subject = strtoupper($site) . " - Bing WM URL Batch Submission - " . $submit_for_dt;
    $status = '**PASS**';

    $body = '<html><title>' . $subject . '</title>';
    $body .= '<body><ul>';
    $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: initiating batch url submission</li>';
    debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: initiating batch url submission');

    $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: service url - </li>';
    $body .= '<li><b>' . $service_url . '</b></li>';

    debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: service url: ' . $service_url);

    debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: table name ' . $table);
    $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: table name - ' . $table . '</li>';

    // check if
    $checktable = $db->rawQuery("SHOW TABLES LIKE '$p_table'");
    $table_exists = count($checktable) > 0 ? true: false;

    if($table_exists) {
        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: table exists');
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: table exists</li>';

        /*  NOT USED
        // total urls to be submitted to bing
        $db->where('site', $site);
        $db->where('served_from', $served_a, 'IN');
        $db->where('agent', 'user');
        $db->where('creation_date', $date->format('Y-m-d'), '<');
        $count = $db->getValue($table, 'count(*)');
        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: total urls for submission - ' . $count);
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: total urls for submission - <b>' . $count . '</b></li>';
        */

        #$url_query_sql = "SELECT site, agent, cache_name c FROM $p_table where site = '$site' and served_from in ($served_s) and agent = 'user' and INSTR(`cache_name`, '_') > 4 and creation_date < '$date_ymd' ";

        $url_query_sql = "SELECT DISTINCT site, agent, cache_name FROM $p_table where site = '$site_url' and served_from in ($served_s) and agent = 'user' and cache_name REGEXP '^(?:[^_]*_){" . $CFG->bng_wm_url_min_seps . "}' ";

        if ($start_date != '' && $end_date != '') {
            $url_query_sql =  $url_query_sql . " and creation_date > '$start_date' and creation_date < '$end_date' ";
        }
        else {
            $url_query_sql =  $url_query_sql . " and creation_date < '$date_ymd' ";
        }

        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: url query sql');
        debug_to_console($url_query_sql);
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: url query sql - </li>';
        $body .= '<li><b>' . $url_query_sql . '</b></li>';

        // get all new urls to be submitted to bing
        $result = $db->rawQuery($url_query_sql);

        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: total urls for submission -' . count($result));
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: total urls for submission - <b>' . count($result) . '</b></li>';

        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: urls to be submitted - ');
        //debug_to_console($result);
    
        //$body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: urls to be submitted<br>';
        //$body .= '<table border="1">';

        $total_urls_a = array();
        foreach($result as $child) {

            $url = 'https://' . $site_url . $site_details['search_uri'] . str_replace('_', '-', $child['cache_name']);
            array_push($total_urls_a, $url);
            
            //$body .= '<tr><td>' . $child['site'] . '</td><td>' . $child['agent'] . '</td><td>' . $child['cache_name'] . '</td><td>' . $url . '</td></tr>';

        }
        //$body .= '</table>';
        //$body .= '</li>';
        

        //echo json_encode($total_urls_a);

        if(count($total_urls_a) > 0) {
            // bing has limit of 500 urls per batch; if urls list is more than 500, we need to make multiple calls
            $url_chunks_a = array_chunk ($total_urls_a, $CFG->bng_wm_batchurl_size_limit);

            debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: number of chunks for submission -' . count($url_chunks_a));
            $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: number of chunks for submission - <b>' . count($url_chunks_a) . '</b></li>';

            foreach($url_chunks_a as $url_a) {
                debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: chunk size being submitted -' . count($url_a));
                $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: chunk size being submitted - <b>' . count($url_a) . '</b></li>';

                if($publish == 'true') {
                    debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: publishing the chunk - START');
                    $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: publishing the chunk - START</li>';
                    
                    // bing api key
                    $api_key = $CFG->bng_wm_api_key;
                    if($site == 'lw') { // use different key for lessonworksheets
                        $api_key = $CFG->bng_lw_wm_api_key;
                    }

                    // The data to send to the API
                    $postData = array(
                        'siteUrl' => 'http://' . $site_url,
                        'urlList' => $url_a
                    );

                    //echo json_encode($postData);

                    // Setup cURL
                    $ch = curl_init($CFG->bng_wm_json_api_base_url . 'SubmitUrlbatch?apikey='. $api_key);

                    curl_setopt_array($ch, array(
                        CURLOPT_POST => TRUE,
                        CURLOPT_RETURNTRANSFER => TRUE,
                        CURLOPT_HTTPHEADER => array(
                            'Content-Type: application/json; charset=utf-8',
                            'Host: ssl.bing.com'
                        ),
                        CURLOPT_POSTFIELDS => json_encode($postData)
                    ));

                    // Send the request
                    $response = curl_exec($ch);

                    // Check for errors
                    if($response === FALSE){
                        die(curl_error($ch));
                    }

                    // Decode the response
                    $responseData = json_decode($response, TRUE);

                    // Print the date from the response
                    //echo $response;

                    debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: publishing the chunk - STATUS');
                    debug_to_console($response);

                    $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: publishing the chunk - STATUS</li>';
                    $body .= '<li>' . $response . '</li>';

                    debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: publishing the chunk - END');
                    $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: publishing the chunk - END</li>';
                }
            }
        }
    }

    else {
        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: ERROR - table does not exist');
        debug_to_console((new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: ERROR - url submission aborted');
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: <b>ERROR - table does not exist</b></li>';
        $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: <b>ERROR - url submission aborted</b></li>';
        $status = '**FAIL**';
    }

    debug_to_console(date("d-m-Y H:i:s.u") . ': bing wm batchurl: email being sent.');
    $body .= '<li>' . (new DateTime)->format("d-m-Y H:i:s.u") . ': bing wm batchurl: email being sent.</li>';
    $body .= "</ul></body></html>";

    sendsmtpmail("no-reply@webilify.com", "sysadmin@rokkada.com,kunmans@gmail.com,kunmans@live.com,sysadmin@webilify.com", $status . ' ' . $subject, $body);
    debug_to_console(date("d-m-Y H:i:s.u") . ': bing wm batchurl: email sent.');
    echo $body;

