<?php
    header('Content-Type: application/json');
    set_time_limit(300); // 5mins
    /*
     * this is cron job to be run with specific parameters to get top pages for a given date range
     */

    include '../config.php';
    include '../lib/util.php'; // this contains ga api calls
    
    require_once '../client/bingc.lib.php'; // client for search service calls to get results metadata

    global $CFG;
    $json_store = $CFG->ga_reports_store;
    $default_count = 10;
    $report_type = 'pageviews';

    $site = $_GET['site']; // pw, lk, km, pkw, twuk, lw, ccws, pcp, cpuk
    $type = $_GET['type']; //  ws or cp
    $scope = $_GET['scope']; // today, yesterday, last7days, last30days, mtd, ytd, lm, lw
    $start_date = $_GET['start_date']; // YYYY-MM-DD, today, yesterday, NdaysAgo
    $end_date = $_GET['end_date']; // YYYY-MM-DD, today, yesterday, NdaysAgo
    $country = $_GET['country']; // United States, United Kingdom, India, Philippines, Australia, Canada
    $country_code = $_GET['country_code']; //us, uk, in, ph, au, ca
    $count = $_GET['count'];
    $error = '';
    $report_name = '';
    $output = array(
    'report_name' => 'Most Page Views',
        'date_created' => date("m/d/Y h:i:s a", time()),
        'site' => $site,
        'start_date' => $start_date,
        'end_date' => $end_date,
        'country' => $country,
        'country_code' => $country_code,
        'count' => $count
    );

    debug_to_console('ascga service - Inside ascga_build_pageviews_json.php');
    debug_to_console('ascga service - Passed metadata below');
    debug_to_console($output);

    // if main params are null write empty json with error message
    if ($site === '' || $start_date === '' || $end_date === '' || $type === '') {
        debug_to_console('ascga service - FATAL ERROR: some params missing or empty');
        $output['error'] = 'Fatal: some params are empty';
    }

    // if no errors
    if($error === '') {
        $filters = '';
        $sitecfg = $CFG->sites[$site];
        if(!$sitecfg) {
            debug_to_console('ascga service - FATAL ERROR: site config not found...Exiting.');
            exit;
        }
        debug_to_console('ascga service - sitecfg below');
        debug_to_console(json_encode($sitecfg));

        if ($count === '' || $count > 20) {
            $count = $default_count;
        }

        // build report file name
        $report_name = 'ascga_' . $site . '_' . $report_type . '_' . $scope . '_' . $country_code . '.json';

        debug_to_console('ascga service - reportname->' . $report_name);
        if ($country_code <> 'wo') {
            $filters .= 'ga:country==' . $country;
        }

        $options = array(
            'dimensions' => 'ga:hostname,ga:pagePath,ga:pageTitle',
            //'filters' => $filters,
            'sort' => '-ga:pageviews',
        );

        if($filters <> '') {
            $options['filters'] = $filters;
        }

        debug_to_console('ascga service - calling ga api util');
        $gadata = getPageViews($sitecfg['ga_view_id'], $start_date, $end_date, $options);

        /*
         * output json should include
         * report_type, date_created, site, count, start_date, end_date, country
         * list of top pages - with title, url, desc, viewcount,
         *
         *
         */
        $cati = 0; // only categories
        $wscpi = 0; // only ws or cp
        $mixi = 0; // mix of cat and ws/cp

        $page_a = null;
        $cat_a = null;
        $mix_a = null;

        if (count($gadata['rows']) > 0) {

            foreach ($gadata['rows'] as $ga) {
                $ga_hostname = $ga[0];
                $ga_pagepath = $ga[1];
                $ga_pagetitle = $ga[2];
                $ga_viewcount = $ga[3];

                debug_to_console('ascga service - hostname->' . $ga_hostname . ', pagepath->' . $ga_pagepath . ', pagetitle->' . $ga_pagetitle . ', viewcount->' . $ga_viewcount);

                $bclient = new bingc\client();

                //debug_to_console('ascga service - is it worksheet->' . strposa($ga_pagepath, $sitecfg['wscp_filters']));
                if(strposa($ga_pagepath, $sitecfg['wscp_filters']) && strposa($ga_pagepath, $sitecfg['cat_filters']) === false) {
                    debug_to_console('ascga service - is it worksheet???? Yes- ' . $ga_pagepath);
                }
                else {
                    debug_to_console('ascga service - is it worksheet???? No- ' . $ga_pagepath);
                }

                // it is a worksheet
                if ($ga_pagepath === '/') { // home page - ignore
                    debug_to_console('ascga service - home page - ignore');
                    continue;
                }
                //elseif ((strpos($ga_pagepath, $sitecfg['wscp_urlstr']) !== false || strpos($ga_pagepath, $sitecfg['wscp_paramstr']) !== false) && strpos($ga_pagepath, $sitecfg['cat_urlstr']) == false && $wscpi <= $count) { // worksheet
                elseif (strposa($ga_pagepath, $sitecfg['wscp_filters']) && strposa($ga_pagepath, $sitecfg['cat_filters']) === false && $wscpi <= $count) { // worksheet

                    debug_to_console('ascga service - worksheet');
                    $keyword = '';
                    $desc = '';
                    $record = '';
                    //
                    // extract keyword from pagepath
                    if (strpos($ga_pagepath, '=') !== false) {
                        $keyword = explode('=', $ga_pagepath)[1];
                        // this is a special case to remove old pagination param dp from keyword (only in pw)
                        $keyword = explode('&', $keyword)[0];
                        debug_to_console('ascga service - old param keyword->' . $keyword);
                    }
                    elseif (strpos($ga_pagepath, '/') !== false) {
                        $keyword = explode('/', $ga_pagepath)[count(explode('/', $ga_pagepath))-1];
                        debug_to_console('ascga service - slash keyword->' . $keyword);
                    }

                    // check if keyword is part of any restricted keywords like super teacher, if yes, skip
                    if(in_array($keyword, $sitecfg['restricted_keywords'])) {
                        debug_to_console('ascga service - restricted keyword->' . $keyword);
                        continue;
                    }

                    $response = $bclient->get($keyword, $sitecfg['type'], $sitecfg['type'] . '.' . $_SERVER['HTTP_HOST']);
                    //debug_to_console($response);
                    $desc = str_replace('|', ', ', $bclient->clean_result_titles($response));
                    debug_to_console('ascga service - worksheet desc->' . $desc);

                    $record = array(
                        "ga_hostname" => $ga_hostname,
                        "ga_pagepath" => $ga_pagepath,
                        'ga_pagetitle' => $ga_pagetitle,
                        "ga_viewcount" => $ga_viewcount,
                        "title" => trim(explode(' - ', $ga_pagetitle)[0]),
                        "pagepath" => $sitecfg['search_uri'] . $response['data']['query']['keyword']['slug'],
                        "slug" => $response['data']['query']['keyword']['slug'],
                        "desc" => $desc
                    );
                    $page_a[$wscpi] = $record;

                    $wscpi++;
                }
                //elseif ((strpos($ga_pagepath, $sitecfg['cat_urlstr']) > 0 || (strpos($ga_pagepath, $sitecfg['wscp_urlstr']) == -1 && strpos($ga_pagepath, $sitecfg['wscp_paramstr']) == -1)) && $cati <= $count) { // category
                elseif (strposa($ga_pagepath, $sitecfg['cat_filters']) && $cati <= $count) { // category
                    debug_to_console('ascga service - category');
                    
                    // skip if the url points to any restricted categories like invalid-worksheets, invalid-coloring-pages
                    $keyword = '';
                    if (strpos($ga_pagepath, '/') !== false) {
                        $keyword = explode('/', $ga_pagepath)[count(explode('/', $ga_pagepath))-1];
                        debug_to_console('ascga service - slash keyword->' . $keyword);
                    }

                    // check if keyword is part of any restricted keywords like super teacher, if yes, skip
                    if(in_array($keyword, $sitecfg['restricted_keywords'])) {
                        debug_to_console('ascga service - restricted cat keyword->' . $keyword);
                        continue;
                    }

                    $record = array(
                        "ga_hostname" => $ga_hostname,
                        "ga_pagepath" => $ga_pagepath,
                        'ga_pagetitle' => $ga_pagetitle,
                        "ga_viewcount" => $ga_viewcount,
                        "title" => trim(explode(' - ', $ga_pagetitle)[0]),
                        "pagepath" => $ga_pagepath,
                        "slug" => '',
                        "desc" => ''
                    );

                    $cat_a[$cati] = $record;
                    $cati++;
                }
                // add record to mixed list
                // this block can be put inside if then blocks above if only wscp and cats need to present in mixed
                if($mixi <= $count) {
                    $mix_a[$mixi] =  $record;
                    $mixi++;
                }

                // break when all 3 lists reach the output count
                if ($cati >= $count && $wscpi >= $count && $mixi >= $count) {
                    debug_to_console('ascga service - $cati->' . $cati . ', wscpi->' . $wscpi . ', mixi->' . $mixi);
                    debug_to_console('ascga service - count reached...breaking.');
                    break;
                }
            }
        } // gacount is not zero
        $output['pages'] = $page_a;
        $output['categories'] = $cat_a;
        $output['mixed'] = $mix_a;

        //echo json_encode($output, JSON_PRETTY_PRINT);
        // write to file
        $fp = fopen($json_store . $report_name, 'w');
        fwrite($fp, json_encode($output));
        fclose($fp);
        echo 'job completed!';

    } // if no error



