<?php

    error_reporting(0); // this it to suppress warnings

    unset($CFG);

    global $CFG;

    $CFG = new stdClass();

    $CFG->browser_debug_log = true; // debug logs are written to browser console
    $CFG->server_debug_log = true; // debug logs are to error log on the server

    $CFG->search_service_url = 'http://localhost/asc/server/search_service.php';
    $CFG->keyword_service_url = 'http://localhost/asc/server/keyword_service.php';
    $CFG->geoip_service_url = 'http://localhost/asc/server/geoip_service.php';

    //Production Settings
    //$CFG->search_service_url = 'http://asb-server.rokkada.com/v2/search_service.php';
    //$CFG->keyword_service_url = 'http://asb-server.rokkada.com/v2/keyword_service.php';
    //$CFG->geoip_service_url = 'http://asb-server.rokkada.com/v2/geoip_service.php';

    $CFG->header_keys = array(
        //'OPENSSL_CONF',
        //'PATH',
        'HTTP_HOST',
        'HTTP_CONNECTION',
        'HTTP_CACHE_CONTROL',
        'HTTP_UPGRADE_INSECURE_REQUESTS',
        'HTTP_USER_AGENT',
        'HTTP_ACCEPT',
        'HTTP_ACCEPT_ENCODING',
        'HTTP_ACCEPT_LANGUAGE',
        'HTTP_COOKIE',
        //'SystemRoot',
        //'COMSPEC',
        //'PATHEXT',
        //'WINDIR',
        //'SERVER_SIGNATURE',
        //'SERVER_SOFTWARE',
        //'SERVER_NAME',
        //'SERVER_ADDR',
        //'SERVER_PORT',
        'REMOTE_ADDR',
        //'DOCUMENT_ROOT',
        //'REQUEST_SCHEME',
        //'CONTEXT_PREFIX',
        //'CONTEXT_DOCUMENT_ROOT',
        //'SERVER_ADMIN',
        //'SCRIPT_FILENAME',
        'REMOTE_PORT',
        //'GATEWAY_INTERFACE',
        //'SERVER_PROTOCOL',
        'REQUEST_METHOD',
        'QUERY_STRING',
        'REQUEST_URI',
        //'SCRIPT_NAME',
        //'PHP_SELF',
        'REQUEST_TIME_FLOAT',
        'REQUEST_TIME',
    );


    if (!function_exists('debug_to_console')) {
        function debug_to_console($data) {
            global $CFG;

            $output = '';
            if (is_array($data)) {

                if ($CFG->browser_debug_log)
                    $output = "<script>console.log( 'Debug: " . http_build_query($data, '', ', ') . "' );</script>";

                if ($CFG->server_debug_log)
                    error_log(print_r($data, TRUE), 0);

            } else {
                if ($CFG->browser_debug_log)
                    $output = "<script>console.log( 'Debug: " . $data . "' );</script>";

                if ($CFG->server_debug_log)
                    error_log($data, 0);
            }
            echo $output;
        }
    }



    $CFG->site_name = "Printable Coloring Pages";
    $CFG->site_url = 'http://pcp.in'; // dev
    //$CFG->site_url = 'https://printablecoloringpages.in'; // prod
    $CFG->site_type = 'cp';
    $CFG->site_meta_title = 'Home';
    $CFG->site_meta_title_suffix = 'Free Coloring Pages';
    $CFG->site_meta_desc = 'Free Printable Coloring Pages - Search &amp; print thousands of coloring pages. Browse quick-find categories to find your coloring page quickly.';
    $CFG->site_meta_keywords = 'Free, Coloring,, Alphabet, Animals, Birthday, Boys, Buildings, Cartoons, Countries, Fantasy, Food, Girls, Holidays, Months, Music, Nature, People, Sports, Toys, Transportation, why coloring, learn colors, mix colors, india, cricket, ganesha, krishna, diwali, rama, sita, ravana, lakshmama, gandhiji, rangoli, god, godess, bike, scooter, car, etc ';

    $CFG->site_content_json = 'data/pcp-content.json';
    $CFG->old_search_param = 'zq'; // for existing site search url param

    $CFG->search_box_placeholder = 'Enter coloring page name...'; // used in search form input
    $CFG->no_results_message = 'Oops...no coloring pages found.  Check & try again with correct coloring page name.'; // used in sresults.php

    $CFG->site_search_uri = $CFG->site_url.'/coloring/';
    $CFG->invalid_search_url = $CFG->site_url.'/invalid-coloring-pages'; // this to match key in data json
    $CFG->unauth_search_url = $CFG->site_url.'/invalid-coloring-pages'; // this to match key in data json

    // this is for managing local search history
    $CFG->hconfig = array(
        "id" => "pcp",
        "path" => "C:\bing-cache\client\pcp.sync",
        //"path" => "/home/indiael1/public_html/sites/v1/hcache/pcp.sync", //production
        "size" => "15"
    );


    // whether to show social locker or not
    $CFG->show_locker = false;

    //sb ad display target countries
    // India, Philiphines, Pakistan, Emirates, Bangladesh, Srilanka, South Africa, Saudi Arabia
    $CFG->sb_ad_target_countries = array ('IN', 'PH', 'PK', 'AE', 'BD', 'LK', 'ZA', 'SA');


    // ads script
    $CFG->g_ad_top_banner = '<script async src="//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
                                        <!-- PCP_RES_TOP -->
                                        <ins class="adsbygoogle"
                                             style="display:block"
                                             data-ad-client="ca-pub-6997161217503277"
                                             data-ad-slot="2154412025"
                                             data-ad-format="auto"></ins>
                                        <script>
                                            (adsbygoogle = window.adsbygoogle || []).push({});
                                        </script>';

    $CFG->g_ad_search_right = '<script async src="//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
                                        <!-- PCP_RES_TOP -->
                                        <ins class="adsbygoogle"
                                             style="display:block"
                                             data-ad-client="ca-pub-6997161217503277"
                                             data-ad-slot="2154412025"
                                             data-ad-format="auto"></ins>
                                        <script>
                                            (adsbygoogle = window.adsbygoogle || []).push({});
                                        </script>';

    $CFG->g_ad_body_main = '<script async src="//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
                                        <!-- PCP_RES_MAIN -->
                                        <ins class="adsbygoogle"
                                             style="display:block"
                                             data-ad-client="ca-pub-6997161217503277"
                                             data-ad-slot="2374738024"
                                             data-ad-format="auto"></ins>
                                        <script>
                                        (adsbygoogle = window.adsbygoogle || []).push({});
                                        </script>';

    $CFG->g_ad_body_right = '<script async src="//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
                                        <!-- PCP_RES_MAIN -->
                                        <ins class="adsbygoogle"
                                             style="display:block"
                                             data-ad-client="ca-pub-6997161217503277"
                                             data-ad-slot="8985086828"
                                             data-ad-format="auto"></ins>
                                        <script>
                                        (adsbygoogle = window.adsbygoogle || []).push({});
                                        </script>';

    $CFG->g_page_ad_script = '<script async src="//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
                                            <script>
                                            (adsbygoogle = window.adsbygoogle || []).push({
                                                google_ad_client: "ca-pub-6997161217503277",
                                                enable_page_level_ads: true
                                              });
                                            </script>'; // this is inserted in the header to enable page level ads for mobile

    // SKOOLBOX ADS
    // 300x250 - is your school ready for skoolbox?
    $CFG->sb_ad_body_right = '<script type="text/javascript">
                                    var bannersnack_embed = {"hash":"bcpad0alt","width":300,"height":250,"t":1471583891,"userId":24964696,"type":"html5"};
                                  </script>
                                <script type="text/javascript" src="//cdn.bannersnack.com/iframe/embed.js"></script>';

    // 300x600
    /*
    '<script type="text/javascript">
               var bannersnack_embed = {"hash":"bxn8rasf1","width":300,"height":600,"t":1471587383,"userId":24964696,"type":"html5"};
               </script>
               <script type="text/javascript" src="//cdn.bannersnack.com/iframe/embed.js"></script>';
    */

    // end of ad script

    // g analytics script
    $CFG->g_analytics_script = '<script type="text/javascript">
                                          var _gaq = _gaq || [];
                                          _gaq.push([\'_setAccount\', \'UA-26769134-1\']);
                                          _gaq.push([\'_trackPageview\']);

                                          (function() {
                                              var ga = document.createElement(\'script\'); ga.type = \'text/javascript\'; ga.async = true;
                                              ga.src = (\'https:\' == document.location.protocol ? \'https://ssl\' : \'http://www\') + \'.google-analytics.com/ga.js\';
                                              var s = document.getElementsByTagName(\'script\')[0]; s.parentNode.insertBefore(ga, s);
                                          })();

                                        </script>';
    // end of g analytics script

?>